/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.domain.Parameter;
import java.util.List;
import java.util.Map;

public class URIBuilder {
    public static String buildURIFromPattern(String pattern, List<Parameter> parameters) {
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String wadltemplate = "{" + parameter.getName() + "}";
                String swaggerTemplate = "/:" + parameter.getName();
                if (pattern.contains(wadltemplate)) {
                    pattern = pattern.replace(wadltemplate, parameter.getValue());
                    continue;
                }
                if (pattern.contains(swaggerTemplate)) {
                    pattern = pattern.replace(":" + parameter.getName(), parameter.getValue());
                    continue;
                }
                if (!pattern.contains("?")) {
                    pattern = pattern + "?";
                }
                if (pattern.contains("=")) {
                    pattern = pattern + "&";
                }
                pattern = pattern + parameter.getName() + "=" + parameter.getValue();
            }
        }
        return pattern;
    }

    public static String buildURIFromPattern(String pattern, Map<String, String> parameters) {
        if (parameters != null) {
            for (String parameterName : parameters.keySet()) {
                String wadltemplate = "{" + parameterName + "}";
                String swaggerTemplate = "/:" + parameterName;
                if (pattern.contains(wadltemplate)) {
                    pattern = pattern.replace(wadltemplate, parameters.get(parameterName));
                    continue;
                }
                if (pattern.contains(swaggerTemplate)) {
                    pattern = pattern.replace(":" + parameterName, parameters.get(parameterName));
                    continue;
                }
                if (!pattern.contains("?")) {
                    pattern = pattern + "?";
                }
                if (pattern.contains("=")) {
                    pattern = pattern + "&";
                }
                pattern = pattern + parameterName + "=" + parameters.get(parameterName);
            }
        }
        return pattern;
    }
}

