/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.SoapMessageValidator;
import io.github.microcks.util.soapui.SoapUIScriptEngineBinder;
import io.github.microcks.util.soapui.SoapUIXPathBuilder;
import io.github.microcks.web.MockControllerCommons;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.HttpServletRequest;
import javax.xml.xpath.XPathExpression;
import org.apache.xmlbeans.XmlError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.xml.sax.InputSource;

@RestController
@RequestMapping(value={"/soap"})
public class SoapController {
    private static Logger log = LoggerFactory.getLogger(SoapController.class);
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${validation.resourceUrl}")
    private final String resourceUrl;

    public SoapController() {
        this.resourceUrl = null;
    }

    @RequestMapping(value={"/{service}/{version}/**"}, method={RequestMethod.POST})
    public ResponseEntity<?> execute(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @RequestParam(value="validate", required=false) Boolean validate, @RequestParam(value="delay", required=false) Long delay, @RequestBody String body, HttpServletRequest request) {
        log.info("Servicing mock response for service [{}, {}]", (Object)serviceName, (Object)version);
        log.debug("Toto");
        log.debug("Request body: " + body);
        long startTime = System.currentTimeMillis();
        if (serviceName.contains("+")) {
            serviceName = serviceName.replace('+', ' ');
        }
        log.info("Service name: " + serviceName);
        Service service = this.serviceRepository.findByNameAndVersion(serviceName, version);
        Operation rOperation = null;
        for (Operation operation : service.getOperations()) {
            if (!this.hasPayloadCorrectStructureForOperation(body, operation.getInputName())) continue;
            rOperation = operation;
            log.info("Found valid operation {}", (Object)rOperation.getName());
            break;
        }
        if (rOperation != null) {
            log.debug("Found a valid operation with rules: {}", (Object)rOperation.getDispatcherRules());
            if (validate != null && validate.booleanValue()) {
                log.debug("Soap message validation is turned on, validating...");
                try {
                    List<XmlError> errors = SoapMessageValidator.validateSoapMessage(rOperation.getInputName(), service.getXmlNS(), body, this.resourceUrl + service.getName() + "-" + version + ".wsdl", true);
                    log.debug("SoapBody validation errors: " + errors.size());
                    if (errors != null && errors.size() > 0) {
                        return new ResponseEntity(errors, HttpStatus.BAD_REQUEST);
                    }
                }
                catch (Exception e) {
                    log.error("Error during Soap validation", (Throwable)e);
                }
            }
            Response response = null;
            String dispatchCriteria = null;
            if ("QUERY_MATCH".equals(rOperation.getDispatcher())) {
                dispatchCriteria = this.getDispatchCriteriaFromXPathEval(rOperation, body);
            } else if ("SCRIPT".equals(rOperation.getDispatcher())) {
                dispatchCriteria = this.getDispatchCriteriaFromScriptEval(rOperation, body, request);
            }
            log.debug("Dispatch criteria for finding response is {}", (Object)dispatchCriteria);
            List<Response> responses = this.responseRepository.findByOperationIdAndDispatchCriteria(IdBuilder.buildOperationId(service, rOperation), dispatchCriteria);
            if (!responses.isEmpty()) {
                response = responses.get(0);
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.valueOf((String)"text/xml;charset=UTF-8"));
            String responseContent = MockControllerCommons.renderResponseContent(body, null, request, response);
            if (delay == null && rOperation.getDefaultDelay() != null) {
                delay = rOperation.getDefaultDelay();
            }
            MockControllerCommons.waitForDelay(startTime, delay);
            MockControllerCommons.publishMockInvocation(this.applicationContext, this, service, response, startTime);
            if (response.isFault()) {
                return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        log.debug("No valid operation found and Microcks...");
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    protected boolean hasPayloadCorrectStructureForOperation(String payload, String operationName) {
        String openingPattern = "(.*):Body>(\\s*)<((\\w+):|)" + operationName + "(.*)>(.*)";
        String closingPattern = "(.*)</((\\w+):|)" + operationName + ">(\\s*)</(.*):Body>(.*)";
        Pattern op = Pattern.compile(openingPattern, 32);
        Pattern cp = Pattern.compile(closingPattern, 32);
        return op.matcher(payload).matches() && cp.matcher(payload).matches();
    }

    private String getDispatchCriteriaFromXPathEval(Operation operation, String body) {
        try {
            XPathExpression xpath = SoapUIXPathBuilder.buildXPathMatcherFromRules(operation.getDispatcherRules());
            return xpath.evaluate(new InputSource(new StringReader(body)));
        }
        catch (Exception e) {
            log.error("Error during Xpath evaluation", (Throwable)e);
            return null;
        }
    }

    private String getDispatchCriteriaFromScriptEval(Operation operation, String body, HttpServletRequest request) {
        ScriptEngineManager sem = new ScriptEngineManager();
        try {
            ScriptEngine se = sem.getEngineByExtension("groovy");
            SoapUIScriptEngineBinder.bindSoapUIEnvironment(se, body, request);
            return (String)se.eval(operation.getDispatcherRules());
        }
        catch (Exception e) {
            log.error("Error during Script evaluation", (Throwable)e);
            return null;
        }
    }
}

