/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Secret;
import io.github.microcks.repository.SecretRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SecretController {
    private static Logger log = LoggerFactory.getLogger(SecretController.class);
    @Autowired
    private SecretRepository secretRepository;

    @RequestMapping(value={"/secrets"}, method={RequestMethod.GET})
    public List<Secret> listSecrets(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="20") int size) {
        log.debug("Getting secrets list for page {} and size {}", (Object)page, (Object)size);
        return this.secretRepository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}))).getContent();
    }

    @RequestMapping(value={"/secrets/search"}, method={RequestMethod.GET})
    public List<Secret> searchSecrets(@RequestParam(value="name") String name) {
        log.debug("Searching secrets corresponding to {}", (Object)name);
        return this.secretRepository.findByNameLike(name);
    }

    @RequestMapping(value={"/secrets/count"}, method={RequestMethod.GET})
    public Map<String, Long> countSecrets() {
        log.debug("Counting secrets...");
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.secretRepository.count());
        return counter;
    }

    @RequestMapping(value={"/secrets"}, method={RequestMethod.POST})
    public ResponseEntity<Secret> createSecret(@RequestBody Secret secret) {
        log.debug("Creating new secret: {}", (Object)secret);
        return new ResponseEntity(this.secretRepository.save(secret), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/secrets/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<Secret> saveSecret(@RequestBody Secret secret) {
        log.debug("Saving existing secret: {}", (Object)secret);
        return new ResponseEntity(this.secretRepository.save(secret), HttpStatus.OK);
    }

    @RequestMapping(value={"/secrets/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteService(@PathVariable(value="id") String secretId) {
        log.debug("Removing secret with id {}", (Object)secretId);
        this.secretRepository.deleteById(secretId);
        return new ResponseEntity(HttpStatus.OK);
    }
}

