/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.TestCaseResult;
import io.github.microcks.domain.TestOptionals;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestReturn;
import io.github.microcks.domain.TestRunnerType;
import io.github.microcks.domain.TestStepResult;
import io.github.microcks.repository.EventMessageRepository;
import io.github.microcks.repository.RequestRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.TestResultRepository;
import io.github.microcks.service.TestRunnerService;
import io.github.microcks.util.IdBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Service;

@Service
public class TestService {
    private static Logger log = LoggerFactory.getLogger(TestService.class);
    @Autowired
    private RequestRepository requestRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private EventMessageRepository eventMessageRepository;
    @Autowired
    private TestResultRepository testResultRepository;
    @Autowired
    private TestRunnerService testRunnerService;

    public TestResult launchTests(io.github.microcks.domain.Service service, String testEndpoint, TestRunnerType runnerType, TestOptionals testOptionals) {
        TestResult testResult = new TestResult();
        testResult.setTestDate(new Date());
        testResult.setTestedEndpoint(testEndpoint);
        testResult.setServiceId(service.getId());
        testResult.setRunnerType(runnerType);
        testResult.setTimeout(testOptionals.getTimeout().longValue());
        testResult.setSecretRef(testOptionals.getSecretRef());
        testResult.setOperationsHeaders(testOptionals.getOperationsHeaders());
        this.testResultRepository.save(testResult);
        log.debug("Calling launchTestsInternal() marked as Async");
        this.testRunnerService.launchTestsInternal(testResult, service, runnerType);
        log.debug("Async launchTestsInternal() as now finished");
        return testResult;
    }

    public TestCaseResult reportTestCaseResult(String testResultId, String operationName, List<TestReturn> testReturns) {
        log.info("Reporting a TestCaseResult for testResult {} on operation '{}'", (Object)testResultId, (Object)operationName);
        TestResult testResult = this.testResultRepository.findById(testResultId).orElse(null);
        TestCaseResult updatedTestCaseResult = null;
        for (TestCaseResult testCaseResult : testResult.getTestCaseResults()) {
            if (!testCaseResult.getOperationName().equals(operationName)) continue;
            if (testReturns == null || testReturns.isEmpty()) break;
            String testCaseId = IdBuilder.buildTestCaseId(testResult, operationName);
            this.createTestReturns(testReturns, testCaseId);
            break;
        }
        int times = 0;
        boolean saved = false;
        while (!saved && times < 5) {
            for (TestCaseResult testCaseResult : testResult.getTestCaseResults()) {
                if (!testCaseResult.getOperationName().equals(operationName)) continue;
                updatedTestCaseResult = testCaseResult;
                if (testReturns == null || testReturns.isEmpty()) {
                    log.info("testReturns are null or empty, setting elapsedTime to -I and success to false for {}", (Object)operationName);
                    testCaseResult.setElapsedTime(-1L);
                    testCaseResult.setSuccess(false);
                    break;
                }
                this.updateTestCaseResultWithReturns(testCaseResult, testReturns);
                break;
            }
            try {
                this.updateTestResult(testResult);
                saved = true;
                log.debug("testResult {} has been updated !", (Object)testResult.getId());
            }
            catch (OptimisticLockingFailureException olfe) {
                log.warn("Caught an OptimisticLockingFailureException, trying refreshing for {} times", (Object)times);
                saved = false;
                this.waitSomeRandomMS(5, 50);
                testResult = this.testResultRepository.findById(testResult.getId()).orElse(null);
                ++times;
            }
        }
        return updatedTestCaseResult;
    }

    private void createTestReturns(List<TestReturn> testReturns, String testCaseId) {
        ArrayList<Response> responses = new ArrayList<Response>();
        ArrayList<Request> actualRequests = new ArrayList<Request>();
        ArrayList<EventMessage> eventMessages = new ArrayList<EventMessage>();
        for (TestReturn testReturn : testReturns) {
            if (testReturn.isRequestResponseTest()) {
                testReturn.getResponse().setTestCaseId(testCaseId);
                testReturn.getRequest().setTestCaseId(testCaseId);
                responses.add(testReturn.getResponse());
                actualRequests.add(testReturn.getRequest());
                continue;
            }
            if (!testReturn.isEventTest()) continue;
            testReturn.getEventMessage().setTestCaseId(testCaseId);
            eventMessages.add(testReturn.getEventMessage());
        }
        if (!responses.isEmpty() && !actualRequests.isEmpty()) {
            log.debug("Saving {} responses with testCaseId {}", (Object)responses.size(), (Object)testCaseId);
            this.responseRepository.saveAll(responses);
            for (int i = 0; i < actualRequests.size(); ++i) {
                ((Request)actualRequests.get(i)).setResponseId(((Response)responses.get(i)).getId());
            }
            log.debug("Saving {} requests with testCaseId {}", (Object)responses.size(), (Object)testCaseId);
            this.requestRepository.saveAll(actualRequests);
        }
        if (!eventMessages.isEmpty()) {
            log.debug("Saving {} eventMessages with testCaseId {}", (Object)eventMessages.size(), (Object)testCaseId);
            this.eventMessageRepository.saveAll(eventMessages);
        }
    }

    private void updateTestCaseResultWithReturns(TestCaseResult testCaseResult, List<TestReturn> testReturns) {
        boolean successFlag = true;
        long caseElapsedTime = 0L;
        for (TestReturn testReturn : testReturns) {
            caseElapsedTime += testReturn.getElapsedTime();
            TestStepResult testStepResult = testReturn.buildTestStepResult();
            if (!testStepResult.isSuccess()) {
                successFlag = false;
            }
            testCaseResult.getTestStepResults().add(testStepResult);
        }
        if (testCaseResult.getTestStepResults().size() > 0) {
            testCaseResult.setSuccess(successFlag);
        }
        testCaseResult.setElapsedTime(caseElapsedTime);
        log.debug("testCaseResult for {} have been updated with {} elapsedTime and success flag to {}", new Object[]{testCaseResult.getOperationName(), testCaseResult.getElapsedTime(), testCaseResult.isSuccess()});
    }

    private void updateTestResult(TestResult testResult) {
        boolean globalSuccessFlag = true;
        boolean globalProgressFlag = false;
        long totalElapsedTime = 0L;
        for (TestCaseResult testCaseResult : testResult.getTestCaseResults()) {
            totalElapsedTime += testCaseResult.getElapsedTime();
            if (!testCaseResult.isSuccess()) {
                globalSuccessFlag = false;
            }
            if (testCaseResult.getElapsedTime() != -1L) continue;
            log.debug("testCaseResult.elapsedTime is -1, set globalProgressFlag to true");
            globalProgressFlag = true;
        }
        testResult.setSuccess(globalSuccessFlag);
        testResult.setInProgress(globalProgressFlag);
        testResult.setElapsedTime(totalElapsedTime);
        log.debug("Trying to update testResult {} with {} elapsedTime and success flag to {}", new Object[]{testResult.getId(), testResult.getElapsedTime(), testResult.isSuccess()});
        this.testResultRepository.save(testResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitSomeRandomMS(int min, int max) {
        Object semaphore = new Object();
        long timeout = ThreadLocalRandom.current().nextInt(min, max + 1);
        Object object = semaphore;
        synchronized (object) {
            try {
                semaphore.wait(timeout);
            }
            catch (Exception e) {
                log.debug("waitSomeRandomMS semaphore was interrupted");
            }
        }
    }
}

