/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.asyncapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.microcks.domain.Binding;
import io.github.microcks.domain.BindingType;
import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPIImporter
implements MockRepositoryImporter {
    private static Logger log = LoggerFactory.getLogger(AsyncAPIImporter.class);
    private boolean isYaml = true;
    private JsonNode spec;
    private String specContent;
    private static final List<String> VALID_VERBS = Arrays.asList("subscribe", "publish");

    public AsyncAPIImporter(String specificationFilePath) throws IOException {
        try {
            String line = null;
            BufferedReader reader = Files.newBufferedReader(new File(specificationFilePath).toPath(), Charset.forName("UTF-8"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("{") || line.startsWith("[")) {
                    this.isYaml = false;
                    break;
                }
                if (!line.startsWith("---") && !line.startsWith("asyncapi: ")) continue;
                this.isYaml = true;
                break;
            }
            reader.close();
            byte[] bytes = Files.readAllBytes(Paths.get(specificationFilePath, new String[0]));
            this.specContent = new String(bytes, Charset.forName("UTF-8"));
            ObjectMapper mapper = null;
            mapper = this.isYaml ? new ObjectMapper((JsonFactory)new YAMLFactory()) : new ObjectMapper();
            this.spec = mapper.readTree(bytes);
        }
        catch (Exception e) {
            log.error("Exception while parsing AsyncAPI specification file " + specificationFilePath, (Throwable)e);
            throw new IOException("AsyncAPI spec file parsing error");
        }
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        Service service = new Service();
        service.setName(this.spec.path("info").path("title").asText());
        service.setVersion(this.spec.path("info").path("version").asText());
        service.setType(ServiceType.EVENT);
        service.setOperations(this.extractOperations());
        result.add(service);
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        String name = service.getName() + "-" + service.getVersion();
        name = this.isYaml ? name + ".yaml" : name + ".json";
        Resource resource = new Resource();
        resource.setName(name);
        resource.setType(ResourceType.ASYNC_API_SPEC);
        resource.setContent(this.specContent);
        results.add(resource);
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        ArrayList<Exchange> result = new ArrayList<Exchange>();
        String defaultContentType = this.spec.get("defaultContentType").asText("application/json");
        Iterator channels = this.spec.path("channels").fields();
        while (channels.hasNext()) {
            Map.Entry channel = (Map.Entry)channels.next();
            String channelName = (String)channel.getKey();
            Iterator verbs = ((JsonNode)channel.getValue()).fields();
            while (verbs.hasNext()) {
                Binding b;
                JsonNode binding;
                String bindingName;
                Iterator bindingNames;
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!operation.getName().equals(verbName.toUpperCase() + " " + channelName.trim())) continue;
                JsonNode messageBody = ((JsonNode)verb.getValue()).path("message");
                String contentType = defaultContentType;
                if (messageBody.has("contentType")) {
                    contentType = messageBody.path("contentType").asText();
                }
                if (!messageBody.has("examples")) continue;
                Iterator examples = messageBody.path("examples").elements();
                while (examples.hasNext()) {
                    JsonNode exampleNode = (JsonNode)examples.next();
                    Iterator exampleNames = exampleNode.fieldNames();
                    while (exampleNames.hasNext()) {
                        String exampleName = (String)exampleNames.next();
                        JsonNode example = exampleNode.path(exampleName);
                        if (!example.has("payload")) continue;
                        String exampleValue = this.getExamplePayload(example);
                        EventMessage eventMessage = new EventMessage();
                        eventMessage.setName(exampleName);
                        eventMessage.setContent(exampleValue);
                        eventMessage.setMediaType(contentType);
                        List<Header> headers = this.getExampleHeaders(example);
                        for (Header header : headers) {
                            eventMessage.addHeader(header);
                        }
                        result.add((Exchange)new UnidirectionalEvent(eventMessage));
                    }
                }
                if (((JsonNode)verb.getValue()).has("bindings")) {
                    bindingNames = ((JsonNode)verb.getValue()).path("bindings").fieldNames();
                    while (bindingNames.hasNext()) {
                        bindingName = (String)bindingNames.next();
                        binding = ((JsonNode)verb.getValue()).path("bindings").path(bindingName);
                        switch (bindingName) {
                            case "kafka": {
                                break;
                            }
                            case "amqp1": {
                                b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.AMQP1);
                                if (binding.has("destinationName")) {
                                    b.setDestinationName(binding.path("destinationName").asText());
                                }
                                if (!binding.has("destinationType")) break;
                                b.setDestinationType(binding.path("destinationType").asText());
                            }
                        }
                    }
                }
                if (!messageBody.has("bindings")) continue;
                bindingNames = messageBody.path("bindings").fieldNames();
                while (bindingNames.hasNext()) {
                    bindingName = (String)bindingNames.next();
                    binding = messageBody.path("bindings").path(bindingName);
                    switch (bindingName) {
                        case "kafka": {
                            b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.KAFKA);
                            if (!binding.has("key")) break;
                            b.setKeyType(binding.path("key").path("type").asText());
                            break;
                        }
                    }
                }
            }
        }
        return result;
    }

    private List<Operation> extractOperations() throws MockRepositoryImportException {
        ArrayList<Operation> results = new ArrayList<Operation>();
        Iterator channels = this.spec.path("channels").fields();
        while (channels.hasNext()) {
            Map.Entry channel = (Map.Entry)channels.next();
            String channelName = (String)channel.getKey();
            Iterator verbs = ((JsonNode)channel.getValue()).fields();
            while (verbs.hasNext()) {
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!VALID_VERBS.contains(verbName)) continue;
                String operationName = verbName.toUpperCase() + " " + channelName.trim();
                Operation operation = new Operation();
                operation.setName(operationName);
                operation.setMethod(verbName.toUpperCase());
                if (AsyncAPIImporter.channelHasParts(channelName)) {
                    operation.setDispatcher("URI_PARTS");
                } else {
                    operation.addResourcePath(channelName);
                }
                results.add(operation);
            }
        }
        return results;
    }

    private List<Header> getExampleHeaders(JsonNode example) {
        ArrayList<Header> results = new ArrayList<Header>();
        if (example.has("headers")) {
            Iterator headers = null;
            if (example.path("headers").getNodeType() == JsonNodeType.OBJECT) {
                headers = example.path("headers").fields();
            } else if (example.path("headers").getNodeType() == JsonNodeType.STRING) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode headersNode = mapper.readTree(example.path("headers").asText());
                    headers = headersNode.fields();
                }
                catch (Exception e) {
                    log.warn("Headers value {} is a string but not JSON, skipping it", (Object)example.path("headers").asText());
                }
            }
            if (headers != null) {
                while (headers.hasNext()) {
                    Map.Entry property = (Map.Entry)headers.next();
                    String propertyName = (String)property.getKey();
                    Header header = new Header();
                    header.setName((String)property.getKey());
                    Set headerValues = Arrays.stream(((JsonNode)property.getValue()).asText().split(",")).map(value -> value.trim()).collect(Collectors.toSet());
                    header.setValues(headerValues);
                    results.add(header);
                }
            }
        }
        return results;
    }

    private String getExamplePayload(JsonNode example) {
        if (example.has("payload")) {
            if (example.path("payload").getNodeType() == JsonNodeType.ARRAY || example.path("payload").getNodeType() == JsonNodeType.OBJECT) {
                return example.path("payload").toString();
            }
            return example.path("payload").asText();
        }
        if (example.has("$payloadRef")) {
            String ref = example.path("$payloadRef").asText();
            JsonNode component = this.spec.at(ref.substring(1));
            return this.getExamplePayload(component);
        }
        return null;
    }

    private static boolean operationHasParameters(JsonNode operation) {
        if (!operation.has("parameters")) {
            return false;
        }
        Iterator parameters = operation.path("parameters").fields();
        if (parameters.hasNext()) {
            Map.Entry parameter = (Map.Entry)parameters.next();
            return true;
        }
        return false;
    }

    private static boolean channelHasParts(String channel) {
        return channel.indexOf("/:") != -1 || channel.indexOf("/{") != -1;
    }

    private static Binding retrieveOrInitOperationBinding(Operation operation, BindingType type) {
        Binding binding = null;
        if (operation.getBindings() != null) {
            binding = (Binding)operation.getBindings().get(type);
        }
        if (binding == null) {
            binding = new Binding(type);
            operation.addBinding(type.toString(), binding);
        }
        return binding;
    }
}

