/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.asyncapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Secret;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestReturn;
import io.github.microcks.domain.TestRunnerType;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.SecretRepository;
import io.github.microcks.util.test.AbstractTestRunner;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;

public class AsyncAPITestRunner
extends AbstractTestRunner<HttpMethod> {
    private static Logger log = LoggerFactory.getLogger(AsyncAPITestRunner.class);
    private ObjectMapper mapper = new ObjectMapper();
    private ResourceRepository resourceRepository;
    private SecretRepository secretRepository;
    private ClientHttpRequestFactory clientHttpRequestFactory;
    private String asyncMinionUrl = null;

    public AsyncAPITestRunner(ResourceRepository resourceRepository, SecretRepository secretRepository) {
        this.resourceRepository = resourceRepository;
        this.secretRepository = secretRepository;
    }

    public void setClientHttpRequestFactory(ClientHttpRequestFactory clientHttpRequestFactory) {
        this.clientHttpRequestFactory = clientHttpRequestFactory;
    }

    public void setAsyncMinionUrl(String asyncMinionUrl) {
        this.asyncMinionUrl = asyncMinionUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TestReturn> runTest(Service service, Operation operation, TestResult testResult, List<Request> requests, String endpointUrl, HttpMethod method) throws URISyntaxException, IOException {
        Secret secret;
        if (log.isDebugEnabled()) {
            log.debug("Launching test run on " + endpointUrl + " for ms");
        }
        Resource asyncAPISpecResource = null;
        List<Resource> resources = this.resourceRepository.findByServiceId(service.getId());
        for (Resource resource : resources) {
            if (!ResourceType.ASYNC_API_SPEC.equals((Object)resource.getType())) continue;
            asyncAPISpecResource = resource;
            break;
        }
        ObjectNode jsonArg = this.mapper.createObjectNode();
        jsonArg.put("runnerType", TestRunnerType.ASYNC_API_SCHEMA.toString());
        jsonArg.put("testResultId", testResult.getId());
        jsonArg.put("operationName", operation.getName());
        jsonArg.put("endpointUrl", endpointUrl);
        jsonArg.put("timeoutMS", testResult.getTimeout());
        jsonArg.put("asyncAPISpec", asyncAPISpecResource.getContent().replace("\"", "\\\""));
        if (testResult.getSecretRef() != null && (secret = (Secret)this.secretRepository.findById(testResult.getSecretRef().getSecretId()).orElse(null)) != null) {
            log.debug("Adding the secret '{}' to test specification request", (Object)secret.getName());
            jsonArg.set("secret", this.mapper.valueToTree((Object)secret));
        }
        URI asyncMinionURI = new URI(this.asyncMinionUrl + "/api/tests");
        ClientHttpRequest httpRequest = this.clientHttpRequestFactory.createRequest(asyncMinionURI, HttpMethod.POST);
        httpRequest.getBody().write(this.mapper.writeValueAsBytes((Object)jsonArg));
        httpRequest.getHeaders().add("Content-Type", "application/json");
        try (ClientHttpResponse httpResponse = null;){
            httpResponse = httpRequest.execute();
        }
        return new ArrayList<TestReturn>();
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return null;
    }
}

