/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.test;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Service;
import io.github.microcks.util.SoapMessageValidator;
import io.github.microcks.util.test.HttpTestRunner;
import java.util.List;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.util.UriUtils;

public class SoapHttpTestRunner
extends HttpTestRunner {
    private static Logger log = LoggerFactory.getLogger(SoapHttpTestRunner.class);
    private String resourceUrl = null;

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return HttpMethod.POST;
    }

    @Override
    protected int extractTestReturnCode(Service service, Operation operation, Request request, ClientHttpResponse httpResponse, String responseContent) {
        int code = 0;
        code = super.extractTestReturnCode(service, operation, request, httpResponse, responseContent);
        if (1 == code) {
            return code;
        }
        try {
            List<XmlError> errors = SoapMessageValidator.validateSoapMessage(operation.getOutputName(), service.getXmlNS(), responseContent, this.resourceUrl + UriUtils.encodeFragment((String)service.getName(), (String)"UTF-8") + "-" + service.getVersion() + ".wsdl", true);
            if (!errors.isEmpty()) {
                log.debug("Soap validation errors found " + errors.size() + ", marking test as failed.");
                return 1;
            }
        }
        catch (XmlException e) {
            log.debug("XmlException while validating Soap response message", (Throwable)e);
            return 1;
        }
        return code;
    }
}

