/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.SoapMessageValidator;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.soapui.SoapUIScriptEngineBinder;
import io.github.microcks.util.soapui.SoapUIXPathBuilder;
import io.github.microcks.web.MockControllerCommons;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.HttpServletRequest;
import javax.xml.xpath.XPathExpression;
import org.apache.xmlbeans.XmlError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.xml.sax.InputSource;

@RestController
@RequestMapping(value={"/soap"})
public class SoapController {
    private static Logger log = LoggerFactory.getLogger(SoapController.class);
    private static Pattern operationCapturePattern = Pattern.compile("(.*):Body>(\\s*)<((\\w+):|)(?<operation>\\w+)(.*)(/)?>(.*)", 32);
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${validation.resourceUrl}")
    private final String resourceUrl;

    public SoapController() {
        this.resourceUrl = null;
    }

    @RequestMapping(value={"/{service}/{version}/**"}, method={RequestMethod.POST})
    public ResponseEntity<?> execute(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @RequestParam(value="validate", required=false) Boolean validate, @RequestParam(value="delay", required=false) Long delay, @RequestBody String body, HttpServletRequest request) {
        log.info("Servicing mock response for service [{}, {}]", (Object)serviceName, (Object)version);
        log.debug("Request body: " + body);
        long startTime = System.currentTimeMillis();
        if (serviceName.contains("+")) {
            serviceName = serviceName.replace('+', ' ');
        }
        log.info("Service name: " + serviceName);
        Service service = this.serviceRepository.findByNameAndVersion(serviceName, version);
        Object rOperation = null;
        String action = this.extractSoapAction(request);
        log.debug("Extracted SOAP action from headers: {}", (Object)action);
        if (action != null && action.length() > 0) {
            for (Object operation : service.getOperations()) {
                if (!action.equals(operation.getAction())) continue;
                rOperation = operation;
                log.info("Found valid operation {}", (Object)rOperation.getName());
                break;
            }
        }
        if (rOperation == null) {
            String operationName = this.extractOperationName(body);
            log.debug("Extracted operation name from payload: {}", (Object)operationName);
            if (operationName != null) {
                for (Operation operation : service.getOperations()) {
                    if (!operationName.equals(operation.getInputName()) && !operationName.equals(operation.getName())) continue;
                    rOperation = operation;
                    log.info("Found valid operation {}", (Object)rOperation.getName());
                    break;
                }
            }
        }
        if (rOperation != null) {
            log.debug("Found a valid operation with rules: {}", (Object)rOperation.getDispatcherRules());
            if (validate != null && validate.booleanValue()) {
                log.debug("Soap message validation is turned on, validating...");
                try {
                    List<XmlError> errors = SoapMessageValidator.validateSoapMessage(rOperation.getInputName(), service.getXmlNS(), body, this.resourceUrl + service.getName() + "-" + version + ".wsdl", true);
                    log.debug("SoapBody validation errors: " + errors.size());
                    if (errors != null && errors.size() > 0) {
                        return new ResponseEntity(errors, HttpStatus.BAD_REQUEST);
                    }
                }
                catch (Exception e) {
                    log.error("Error during Soap validation", (Throwable)e);
                }
            }
            String dispatcher = rOperation.getDispatcher();
            String dispatcherRules = rOperation.getDispatcherRules();
            FallbackSpecification fallback = MockControllerCommons.getFallbackIfAny(rOperation);
            if (fallback != null) {
                dispatcher = fallback.getDispatcher();
                dispatcherRules = fallback.getDispatcherRules();
            }
            Response response = null;
            String dispatchCriteria = null;
            if ("QUERY_MATCH".equals(dispatcher)) {
                dispatchCriteria = this.getDispatchCriteriaFromXPathEval(dispatcherRules, body);
            } else if ("SCRIPT".equals(dispatcher)) {
                dispatchCriteria = this.getDispatchCriteriaFromScriptEval(dispatcherRules, body, request);
            }
            log.debug("Dispatch criteria for finding response is {}", (Object)dispatchCriteria);
            List<Response> responses = this.responseRepository.findByOperationIdAndDispatchCriteria(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), dispatchCriteria);
            if (responses.isEmpty() && fallback != null) {
                responses = this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), fallback.getFallback());
            }
            if (!responses.isEmpty()) {
                response = responses.get(0);
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentType(MediaType.valueOf((String)"text/xml;charset=UTF-8"));
            String responseContent = MockControllerCommons.renderResponseContent(body, null, request, response);
            if (delay == null && rOperation.getDefaultDelay() != null) {
                delay = rOperation.getDefaultDelay();
            }
            MockControllerCommons.waitForDelay(startTime, delay);
            MockControllerCommons.publishMockInvocation(this.applicationContext, this, service, response, startTime);
            if (response.isFault()) {
                return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        log.debug("No valid operation found by Microcks...");
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    protected boolean hasPayloadCorrectStructureForOperation(String payload, String operationName) {
        String openingPattern = "(.*):Body>(\\s*)<((\\w+):|)" + operationName + "(.*)>(.*)";
        String closingPattern = "(.*)</((\\w+):|)" + operationName + ">(\\s*)</(.*):Body>(.*)";
        String shortPattern = "(.*):Body>(\\s*)<((\\w+):|)" + operationName + "(.*)/>(\\s*)</(.*):Body>(.*)";
        Pattern op = Pattern.compile(openingPattern, 32);
        Pattern cp = Pattern.compile(closingPattern, 32);
        Pattern sp = Pattern.compile(shortPattern, 32);
        return op.matcher(payload).matches() && cp.matcher(payload).matches() || sp.matcher(payload).matches();
    }

    protected String extractOperationName(String payload) {
        Matcher matcher = operationCapturePattern.matcher(payload);
        if (matcher.find()) {
            return matcher.group("operation");
        }
        return null;
    }

    protected String extractSoapAction(HttpServletRequest request) {
        String action = null;
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("application/soap+xml") && contentType.contains("action=")) {
            action = contentType.substring(contentType.indexOf("action=") + 7);
            if (action.contains(";")) {
                action = action.substring(0, action.indexOf(";"));
            }
        } else {
            action = request.getHeader("SOAPAction");
        }
        if (action != null) {
            if (action.startsWith("\"")) {
                action = action.substring(1);
            }
            if (action.endsWith("\"")) {
                action = action.substring(0, action.length() - 1);
            }
        }
        return action;
    }

    private String getDispatchCriteriaFromXPathEval(String dispatcherRules, String body) {
        try {
            XPathExpression xpath = SoapUIXPathBuilder.buildXPathMatcherFromRules(dispatcherRules);
            return xpath.evaluate(new InputSource(new StringReader(body)));
        }
        catch (Exception e) {
            log.error("Error during Xpath evaluation", (Throwable)e);
            return null;
        }
    }

    private String getDispatchCriteriaFromScriptEval(String dispatcherRules, String body, HttpServletRequest request) {
        ScriptEngineManager sem = new ScriptEngineManager();
        try {
            ScriptEngine se = sem.getEngineByExtension("groovy");
            SoapUIScriptEngineBinder.bindSoapUIEnvironment(se, body, request);
            return (String)se.eval(dispatcherRules);
        }
        catch (Exception e) {
            log.error("Error during Script evaluation", (Throwable)e);
            return null;
        }
    }
}

