/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import io.github.microcks.domain.ServiceState;
import io.github.microcks.repository.ServiceStateRepository;
import io.github.microcks.service.StateStore;
import java.util.Date;
import javax.annotation.Nullable;

public class ServiceStateStore
implements StateStore {
    private static final int DEFAULT_SECONDS_TTL = 10;
    private final ServiceStateRepository repository;
    private final String serviceId;

    public ServiceStateStore(ServiceStateRepository repository, String serviceId) {
        this.repository = repository;
        this.serviceId = serviceId;
    }

    @Override
    public void put(String key, String value) {
        this.put(key, value, 10);
    }

    @Override
    public void put(String key, String value, int secondsTTL) {
        ServiceState state = this.repository.findByServiceIdAndKey(this.serviceId, key);
        if (state == null) {
            state = new ServiceState(this.serviceId, key);
        }
        state.setValue(value);
        state.setExpireAt(new Date(System.currentTimeMillis() + (long)secondsTTL * 1000L));
        this.repository.save(state);
    }

    @Override
    @Nullable
    public String get(String key) {
        ServiceState state = this.repository.findByServiceIdAndKey(this.serviceId, key);
        if (state != null) {
            return state.getValue();
        }
        return null;
    }

    @Override
    public void delete(String key) {
        ServiceState state = this.repository.findByServiceIdAndKey(this.serviceId, key);
        if (state != null) {
            this.repository.delete(state);
        }
    }
}

