/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.asyncapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.domain.Binding;
import io.github.microcks.domain.BindingType;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPICommons {
    private static Logger log = LoggerFactory.getLogger(AsyncAPICommons.class);
    public static final String MESSAGES = "messages";
    public static final String BINDINGS = "bindings";
    public static final String SCHEMA_NODE = "schema";
    public static final String CHANNEL_NODE = "channel";
    public static final String ADDRESS_NODE = "address";
    public static final String PARAMETERS_NODE = "parameters";
    public static final String LOCATION_NODE = "location";
    public static final String EXAMPLES_NODE = "examples";
    public static final String EXAMPLE_VALUE_NODE = "value";
    public static final String EXAMPLE_PAYLOAD_NODE = "payload";
    public static final String EXAMPLE_HEADERS_NODE = "headers";
    public static final String QUEUE_VALUE = "queue";
    public static final String TOPIC_VALUE = "topic";

    private AsyncAPICommons() {
    }

    public static void completeChannelLevelBindings(Operation operation, JsonNode bindings) {
        Iterator bindingNames = bindings.fieldNames();
        block10: while (bindingNames.hasNext()) {
            String bindingName = (String)bindingNames.next();
            JsonNode bindingNode = bindings.path(bindingName);
            switch (bindingName) {
                case "ws": {
                    Binding b = AsyncAPICommons.retrieveOrInitOperationBinding(operation, BindingType.WS);
                    b.setMethod(bindingNode.path("method").asText(null));
                    break;
                }
                case "amqp": {
                    Binding b = AsyncAPICommons.retrieveOrInitOperationBinding(operation, BindingType.AMQP);
                    if (!bindingNode.has("is")) break;
                    String is = bindingNode.path("is").asText();
                    if (QUEUE_VALUE.equals(is)) {
                        b.setDestinationType(QUEUE_VALUE);
                        JsonNode queue = bindingNode.get(QUEUE_VALUE);
                        b.setDestinationName(queue.get("name").asText());
                        break;
                    }
                    if (!"routingKey".equals(is)) continue block10;
                    JsonNode exchange = bindingNode.get("exchange");
                    b.setDestinationType(exchange.get("type").asText());
                    break;
                }
                case "googlepubsub": {
                    Binding b = AsyncAPICommons.retrieveOrInitOperationBinding(operation, BindingType.GOOGLEPUBSUB);
                    b.setDestinationName(bindingNode.path(TOPIC_VALUE).asText(null));
                    b.setPersistent(bindingNode.path("messageRetentionDuration").asBoolean(false));
                    break;
                }
            }
        }
    }

    public static void completeOperationLevelBindings(Operation operation, JsonNode bindings) {
        Iterator bindingNames = bindings.fieldNames();
        while (bindingNames.hasNext()) {
            String bindingName = (String)bindingNames.next();
            JsonNode bindingNode = bindings.path(bindingName);
            switch (bindingName) {
                case "kafka": {
                    break;
                }
                case "mqtt": {
                    Binding b = AsyncAPICommons.retrieveOrInitOperationBinding(operation, BindingType.MQTT);
                    b.setQoS(bindingNode.path("qos").asText(null));
                    b.setPersistent(bindingNode.path("retain").asBoolean(false));
                    break;
                }
                case "amqp1": {
                    Binding b = AsyncAPICommons.retrieveOrInitOperationBinding(operation, BindingType.AMQP1);
                    b.setDestinationName(bindingNode.path("destinationName").asText(null));
                    b.setDestinationType(bindingNode.path("destinationType").asText(null));
                    break;
                }
                case "nats": {
                    Binding b = AsyncAPICommons.retrieveOrInitOperationBinding(operation, BindingType.NATS);
                    b.setDestinationName(bindingNode.path(QUEUE_VALUE).asText(null));
                    break;
                }
                case "sqs": {
                    Binding b = AsyncAPICommons.retrieveOrInitOperationBinding(operation, BindingType.SQS);
                    if (!bindingNode.has(QUEUE_VALUE)) break;
                    b.setDestinationName(bindingNode.get(QUEUE_VALUE).path("name").asText(null));
                    b.setPersistent(bindingNode.path("messageRetentionPeriod").asBoolean(false));
                    break;
                }
                case "sns": {
                    Binding b = AsyncAPICommons.retrieveOrInitOperationBinding(operation, BindingType.SNS);
                    if (!bindingNode.has(TOPIC_VALUE) || !bindingNode.get(TOPIC_VALUE).has("name")) break;
                    b.setDestinationName(bindingNode.get(TOPIC_VALUE).path("name").asText(null));
                    break;
                }
            }
        }
    }

    public static void completeMessageLevelBindings(Operation operation, JsonNode bindings) {
        Iterator bindingNames = bindings.fieldNames();
        while (bindingNames.hasNext()) {
            String bindingName = (String)bindingNames.next();
            JsonNode bindingNode = bindings.path(bindingName);
            switch (bindingName) {
                case "kafka": {
                    Binding b = AsyncAPICommons.retrieveOrInitOperationBinding(operation, BindingType.KAFKA);
                    if (!bindingNode.has("key")) break;
                    b.setKeyType(bindingNode.path("key").path("type").asText());
                    break;
                }
            }
        }
    }

    public static boolean channelAddressHasParts(String address) {
        return address.indexOf("{") != -1;
    }

    public static List<Header> getExampleHeaders(JsonNode example) {
        ArrayList<Header> results = new ArrayList<Header>();
        if (example.has(EXAMPLE_HEADERS_NODE)) {
            Iterator headers = null;
            if (example.path(EXAMPLE_HEADERS_NODE).isObject()) {
                headers = example.path(EXAMPLE_HEADERS_NODE).fields();
            } else if (example.path(EXAMPLE_HEADERS_NODE).isTextual()) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode headersNode = mapper.readTree(example.path(EXAMPLE_HEADERS_NODE).asText());
                    headers = headersNode.fields();
                }
                catch (Exception e) {
                    log.warn("Headers value {} is a string but not JSON, skipping it", (Object)example.path(EXAMPLE_HEADERS_NODE).asText());
                }
            }
            if (headers != null) {
                while (headers.hasNext()) {
                    Map.Entry property = (Map.Entry)headers.next();
                    Header header = new Header();
                    header.setName((String)property.getKey());
                    Set headerValues = Arrays.stream(((JsonNode)property.getValue()).asText().split(",")).map(String::trim).collect(Collectors.toSet());
                    header.setValues(headerValues);
                    results.add(header);
                }
            }
        }
        return results;
    }

    private static Binding retrieveOrInitOperationBinding(Operation operation, BindingType type) {
        Binding binding = null;
        if (operation.getBindings() != null) {
            binding = (Binding)operation.getBindings().get(type.toString());
        }
        if (binding == null) {
            binding = new Binding(type);
            operation.addBinding(type.toString(), binding);
        }
        return binding;
    }
}

