/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.metadata;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.Service;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.metadata.MetadataExtractor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataImporter
implements MockRepositoryImporter {
    private static final Logger log = LoggerFactory.getLogger(MetadataImporter.class);
    private final JsonNode spec;

    public MetadataImporter(String specificationFilePath) throws IOException {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(specificationFilePath, new String[0]));
            String specContent = new String(bytes, StandardCharsets.UTF_8);
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            this.spec = mapper.readTree(specContent.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("Exception while parsing APIMetadata specification file " + specificationFilePath, (Throwable)e);
            throw new IOException("APIMetadata spec file parsing error");
        }
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        Service service = new Service();
        JsonNode metadataNode = this.spec.get("metadata");
        if (metadataNode == null) {
            log.error("Missing mandatory metadata in {}", (Object)this.spec.asText());
            throw new MockRepositoryImportException("Mandatory metadata property is missing in APIMetadata");
        }
        service.setName(metadataNode.path("name").asText());
        service.setVersion(metadataNode.path("version").asText());
        Metadata metadata = new Metadata();
        MetadataExtractor.completeMetadata(metadata, metadataNode);
        service.setMetadata(metadata);
        service.setOperations(this.extractOperations());
        result.add(service);
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) throws MockRepositoryImportException {
        return new ArrayList<Resource>();
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        return new ArrayList<Exchange>();
    }

    private List<Operation> extractOperations() {
        ArrayList<Operation> results = new ArrayList<Operation>();
        Iterator operations = this.spec.path("operations").fields();
        while (operations.hasNext()) {
            Map.Entry operation = (Map.Entry)operations.next();
            Operation op = new Operation();
            op.setName((String)operation.getKey());
            JsonNode operationValue = (JsonNode)operation.getValue();
            MetadataExtractor.completeOperationProperties(op, operationValue);
            results.add(op);
        }
        return results;
    }
}

