/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Parameter;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.AbstractJsonRepositoryImporter;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.ReferenceResolver;
import io.github.microcks.util.URIBuilder;
import io.github.microcks.util.metadata.MetadataExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIImporter
extends AbstractJsonRepositoryImporter
implements MockRepositoryImporter {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIImporter.class);
    private static final List<String> VALID_VERBS = Arrays.asList("get", "put", "post", "delete", "options", "head", "patch", "trace");
    private static final String PARAMETERS_NODE = "parameters";
    private static final String PARAMETERS_QUERY_VALUE = "query";
    private static final String CONTENT_NODE = "content";
    private static final String HEADERS_NODE = "headers";
    private static final String EXAMPLES_NODE = "examples";
    private static final String EXAMPLE_VALUE_NODE = "value";

    public OpenAPIImporter(String specificationFilePath, ReferenceResolver referenceResolver) throws IOException {
        super(specificationFilePath, referenceResolver);
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        Service service = new Service();
        service.setName(this.rootSpecification.path("info").path("title").asText());
        service.setVersion(this.rootSpecification.path("info").path("version").asText());
        service.setType(ServiceType.REST);
        if (this.rootSpecification.path("info").has("x-microcks")) {
            Metadata metadata = new Metadata();
            MetadataExtractor.completeMetadata(metadata, this.rootSpecification.path("info").path("x-microcks"));
            service.setMetadata(metadata);
        }
        this.initializeReferencedResources(service);
        service.setOperations(this.extractOperations());
        result.add(service);
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        String name = service.getName() + "-" + service.getVersion();
        name = Boolean.TRUE.equals(this.isYaml) ? name + ".yaml" : name + ".json";
        Resource resource = new Resource();
        resource.setName(name);
        resource.setType(ResourceType.OPEN_API_SPEC);
        results.add(resource);
        resource.setContent(this.rootSpecificationContent);
        results.addAll(this.externalResources);
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        HashMap<Request, Response> result = new HashMap<Request, Response>();
        Iterator paths = this.rootSpecification.path("paths").fields();
        while (paths.hasNext()) {
            Map.Entry path = (Map.Entry)paths.next();
            String pathName = (String)path.getKey();
            JsonNode pathValue = this.followRefIfAny((JsonNode)path.getValue());
            Map<String, Multimap<String, String>> pathPathParametersByExample = this.extractParametersByExample(pathValue, "path");
            Iterator verbs = pathValue.fields();
            while (verbs.hasNext()) {
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!operation.getName().equals(verbName.toUpperCase() + " " + pathName.trim())) continue;
                Map<String, Multimap<String, String>> pathParametersByExample = this.extractParametersByExample((JsonNode)verb.getValue(), "path");
                pathParametersByExample.putAll(pathPathParametersByExample);
                Map<String, Multimap<String, String>> queryParametersByExample = this.extractParametersByExample((JsonNode)verb.getValue(), PARAMETERS_QUERY_VALUE);
                Map<String, Multimap<String, String>> headerParametersByExample = this.extractParametersByExample((JsonNode)verb.getValue(), "header");
                Map<String, Request> requestBodiesByExample = this.extractRequestBodies((JsonNode)verb.getValue());
                if (!((JsonNode)verb.getValue()).has("responses")) continue;
                DispatchCriteriaHelper.DispatcherDetails details = DispatchCriteriaHelper.extractDispatcherWithRules(operation);
                String rootDispatcher = details.rootDispatcher();
                String rootDispatcherRules = details.rootDispatcherRules();
                Iterator responseCodes = ((JsonNode)verb.getValue()).path("responses").fields();
                while (responseCodes.hasNext()) {
                    Map.Entry responseCode = (Map.Entry)responseCodes.next();
                    Iterator contents = this.getResponseContent((JsonNode)responseCode.getValue()).fields();
                    if (!contents.hasNext() && ((JsonNode)responseCode.getValue()).has("x-microcks-refs")) {
                        result.putAll(this.getNoContentRequestResponsePair(operation, rootDispatcher, rootDispatcherRules, requestBodiesByExample, pathParametersByExample, queryParametersByExample, headerParametersByExample, responseCode));
                    }
                    while (contents.hasNext()) {
                        Map.Entry content = (Map.Entry)contents.next();
                        result.putAll(this.getContentRequestResponsePairs(operation, rootDispatcher, rootDispatcherRules, requestBodiesByExample, pathParametersByExample, queryParametersByExample, headerParametersByExample, responseCode, content));
                    }
                }
            }
        }
        return result.entrySet().stream().map(entry -> new RequestResponsePair((Request)entry.getKey(), (Response)entry.getValue())).collect(Collectors.toList());
    }

    private List<Operation> extractOperations() {
        ArrayList<Operation> results = new ArrayList<Operation>();
        Iterator paths = this.rootSpecification.path("paths").fields();
        while (paths.hasNext()) {
            Map.Entry path = (Map.Entry)paths.next();
            String pathName = (String)path.getKey();
            JsonNode pathValue = this.followRefIfAny((JsonNode)path.getValue());
            Iterator verbs = pathValue.fields();
            while (verbs.hasNext()) {
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!VALID_VERBS.contains(verbName)) continue;
                String operationName = verbName.toUpperCase() + " " + pathName.trim();
                Operation operation = new Operation();
                operation.setName(operationName);
                operation.setMethod(verbName.toUpperCase());
                if (((JsonNode)verb.getValue()).has("x-microcks-operation")) {
                    MetadataExtractor.completeOperationProperties(operation, ((JsonNode)verb.getValue()).path("x-microcks-operation"));
                }
                if (operation.getDispatcher() == null) {
                    if (this.operationHasParameters((JsonNode)verb.getValue(), PARAMETERS_QUERY_VALUE) && OpenAPIImporter.urlHasParts(pathName)) {
                        operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIPattern(pathName) + " ?? " + this.extractOperationParams((JsonNode)verb.getValue()));
                        operation.setDispatcher("URI_ELEMENTS");
                    } else if (this.operationHasParameters((JsonNode)verb.getValue(), PARAMETERS_QUERY_VALUE)) {
                        operation.setDispatcherRules(this.extractOperationParams((JsonNode)verb.getValue()));
                        operation.setDispatcher("URI_PARAMS");
                    } else if (OpenAPIImporter.urlHasParts(pathName)) {
                        operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIPattern(pathName));
                        operation.setDispatcher("URI_PARTS");
                    } else {
                        operation.addResourcePath(pathName);
                    }
                } else {
                    operation.addResourcePath(pathName);
                }
                results.add(operation);
            }
        }
        return results;
    }

    private Map<String, Multimap<String, String>> extractParametersByExample(JsonNode node, String parameterType) {
        HashMap<String, Multimap<String, String>> results = new HashMap<String, Multimap<String, String>>();
        Iterator parameters = node.path(PARAMETERS_NODE).elements();
        while (parameters.hasNext()) {
            JsonNode parameter = this.followRefIfAny((JsonNode)parameters.next());
            String parameterName = parameter.path("name").asText();
            if (!parameter.has("in") || !parameter.path("in").asText().equals(parameterType) || !parameter.has(EXAMPLES_NODE)) continue;
            Iterator exampleNames = parameter.path(EXAMPLES_NODE).fieldNames();
            while (exampleNames.hasNext()) {
                String exampleName = (String)exampleNames.next();
                JsonNode example = parameter.path(EXAMPLES_NODE).path(exampleName);
                JsonNode exampleValue = this.getExampleValue(example);
                if (exampleValue == null) {
                    log.warn("Couldn't find example value for example node: name: {}, data: {}", (Object)exampleName, (Object)example);
                    continue;
                }
                Multimap exampleParams = results.computeIfAbsent(exampleName, k -> ArrayListMultimap.create());
                if (PARAMETERS_QUERY_VALUE.equals(parameterType) && exampleValue.isArray()) {
                    for (Object current : (ArrayNode)exampleValue) {
                        exampleParams.put((Object)parameterName, (Object)this.getValueString((JsonNode)current));
                    }
                    continue;
                }
                if (PARAMETERS_QUERY_VALUE.equals(parameterType) && exampleValue.isObject()) {
                    Iterator fieldsIterator = ((ObjectNode)exampleValue).fields();
                    while (fieldsIterator.hasNext()) {
                        Object current;
                        current = (Map.Entry)fieldsIterator.next();
                        exampleParams.put((Object)((String)current.getKey()), (Object)this.getValueString((JsonNode)current.getValue()));
                    }
                    continue;
                }
                exampleParams.put((Object)parameterName, (Object)this.getValueString(exampleValue));
            }
        }
        return results;
    }

    private Map<String, Request> extractRequestBodies(JsonNode verbNode) {
        HashMap<String, Request> results = new HashMap<String, Request>();
        JsonNode requestBody = verbNode.path("requestBody");
        Iterator contentTypeNames = requestBody.path(CONTENT_NODE).fieldNames();
        while (contentTypeNames.hasNext()) {
            String contentTypeName = (String)contentTypeNames.next();
            JsonNode contentType = requestBody.path(CONTENT_NODE).path(contentTypeName);
            if (!contentType.has(EXAMPLES_NODE)) continue;
            Iterator exampleNames = contentType.path(EXAMPLES_NODE).fieldNames();
            while (exampleNames.hasNext()) {
                String exampleName = (String)exampleNames.next();
                JsonNode example = contentType.path(EXAMPLES_NODE).path(exampleName);
                String exampleValue = this.getSerializedExampleValue(example);
                Request request = new Request();
                request.setName(exampleName);
                request.setContent(exampleValue);
                Header header = new Header();
                header.setName("Content-Type");
                HashSet<String> values = new HashSet<String>();
                values.add(contentTypeName);
                header.setValues(values);
                request.addHeader(header);
                results.put(exampleName, request);
            }
        }
        return results;
    }

    private Map<String, List<Header>> extractHeadersByExample(JsonNode responseNode) {
        HashMap<String, List<Header>> results = new HashMap<String, List<Header>>();
        if ((responseNode = this.followRefIfAny(responseNode)).has(HEADERS_NODE)) {
            JsonNode headersNode = responseNode.path(HEADERS_NODE);
            Iterator headerNames = headersNode.fieldNames();
            while (headerNames.hasNext()) {
                String headerName = (String)headerNames.next();
                JsonNode headerNode = headersNode.path(headerName);
                if (!headerNode.has(EXAMPLES_NODE)) continue;
                Iterator exampleNames = headerNode.path(EXAMPLES_NODE).fieldNames();
                while (exampleNames.hasNext()) {
                    String exampleName = (String)exampleNames.next();
                    JsonNode example = headerNode.path(EXAMPLES_NODE).path(exampleName);
                    String exampleValue = this.getSerializedExampleValue(example);
                    List headersForExample = results.computeIfAbsent(exampleName, k -> new ArrayList());
                    Set values = Arrays.stream(exampleValue.split(",")).map(String::trim).collect(Collectors.toSet());
                    Header header = new Header();
                    header.setName(headerName);
                    header.setValues(values);
                    headersForExample.add(header);
                    results.put(exampleName, headersForExample);
                }
            }
        }
        return results;
    }

    private Map<Request, Response> getContentRequestResponsePairs(Operation operation, String rootDispatcher, String rootDispatcherRules, Map<String, Request> requestBodiesByExample, Map<String, Multimap<String, String>> pathParametersByExample, Map<String, Multimap<String, String>> queryParametersByExample, Map<String, Multimap<String, String>> headerParametersByExample, Map.Entry<String, JsonNode> responseCode, Map.Entry<String, JsonNode> content) {
        HashMap<Request, Response> results = new HashMap<Request, Response>();
        String contentValue = content.getKey();
        Map<String, List<Header>> headersByExample = this.extractHeadersByExample(responseCode.getValue());
        JsonNode examplesNode = this.followRefIfAny(content.getValue().path(EXAMPLES_NODE));
        Iterator exampleNames = examplesNode.fieldNames();
        while (exampleNames.hasNext()) {
            Request request;
            List<Header> responseHeaders;
            String exampleName = (String)exampleNames.next();
            JsonNode example = examplesNode.path(exampleName);
            Response response = new Response();
            response.setName(exampleName);
            response.setMediaType(contentValue);
            response.setStatus(responseCode.getKey());
            response.setContent(this.getSerializedExampleValue(example));
            if (!responseCode.getKey().startsWith("2")) {
                response.setFault(true);
            }
            if ((responseHeaders = headersByExample.get(exampleName)) != null) {
                responseHeaders.stream().forEach(arg_0 -> ((Response)response).addHeader(arg_0));
            }
            if ((request = requestBodiesByExample.get(exampleName)) == null) {
                request = new Request();
                request.setName(exampleName);
            }
            Header header = new Header();
            header.setName("Accept");
            HashSet<String> values = new HashSet<String>();
            values.add(contentValue);
            header.setValues(values);
            request.addHeader(header);
            Multimap<String, String> pathParameters = pathParametersByExample.get(exampleName);
            if (pathParameters != null) {
                this.completeRequestWithPathParameters(request, pathParameters);
            } else if ("URI_PARTS".equals(operation.getDispatcher()) || "URI_ELEMENTS".equals(operation.getDispatcher())) break;
            this.completeRequestWithQueryParameters(request, queryParametersByExample.get(exampleName));
            this.completeRequestWithHeaderParameters(request, headerParametersByExample.get(exampleName));
            this.completeDispatchCriteriaAndResourcePaths(operation, rootDispatcher, rootDispatcherRules, pathParametersByExample, queryParametersByExample, exampleName, response);
            results.put(request, response);
        }
        return results;
    }

    private Map<Request, Response> getNoContentRequestResponsePair(Operation operation, String rootDispatcher, String rootDispatcherRules, Map<String, Request> requestBodiesByExample, Map<String, Multimap<String, String>> pathParametersByExample, Map<String, Multimap<String, String>> queryParametersByExample, Map<String, Multimap<String, String>> headerParametersByExample, Map.Entry<String, JsonNode> responseCode) {
        HashMap<Request, Response> results = new HashMap<Request, Response>();
        JsonNode requestRefs = responseCode.getValue().path("x-microcks-refs");
        if (requestRefs.isArray()) {
            Map<String, List<Header>> headersByExample = this.extractHeadersByExample(responseCode.getValue());
            Iterator requestRefsIterator = requestRefs.elements();
            while (requestRefsIterator.hasNext()) {
                List<Header> responseHeaders;
                String exampleName = ((JsonNode)requestRefsIterator.next()).textValue();
                Request request = requestBodiesByExample.get(exampleName);
                Multimap<String, String> pathParameters = pathParametersByExample.get(exampleName);
                Multimap<String, String> queryParameters = queryParametersByExample.get(exampleName);
                Multimap<String, String> headerParameters = headerParametersByExample.get(exampleName);
                if (request == null && pathParameters == null && queryParameters == null && headerParameters == null) continue;
                if (request == null) {
                    request = new Request();
                    request.setName(exampleName);
                }
                if (pathParameters != null) {
                    this.completeRequestWithPathParameters(request, pathParameters);
                } else if ("URI_PARTS".equals(operation.getDispatcher()) || "URI_ELEMENTS".equals(operation.getDispatcher())) break;
                Response response = new Response();
                response.setName(exampleName);
                response.setStatus(responseCode.getKey());
                if (!responseCode.getKey().startsWith("2")) {
                    response.setFault(true);
                }
                if ((responseHeaders = headersByExample.get(exampleName)) != null) {
                    responseHeaders.stream().forEach(arg_0 -> ((Response)response).addHeader(arg_0));
                }
                this.completeRequestWithQueryParameters(request, queryParametersByExample.get(exampleName));
                this.completeRequestWithHeaderParameters(request, headerParametersByExample.get(exampleName));
                this.completeDispatchCriteriaAndResourcePaths(operation, rootDispatcher, rootDispatcherRules, pathParametersByExample, queryParametersByExample, exampleName, response);
                results.put(request, response);
            }
        }
        return results;
    }

    private void completeRequestWithPathParameters(Request request, Multimap<String, String> pathParameters) {
        for (Map.Entry paramEntry : pathParameters.entries()) {
            Parameter param = new Parameter();
            param.setName((String)paramEntry.getKey());
            param.setValue((String)paramEntry.getValue());
            request.addQueryParameter(param);
        }
    }

    private void completeRequestWithQueryParameters(Request request, Multimap<String, String> queryParameters) {
        if (queryParameters != null) {
            for (Map.Entry paramEntry : queryParameters.entries()) {
                Parameter param = new Parameter();
                param.setName((String)paramEntry.getKey());
                param.setValue((String)paramEntry.getValue());
                request.addQueryParameter(param);
            }
        }
    }

    private void completeRequestWithHeaderParameters(Request request, Multimap<String, String> headerParameters) {
        if (headerParameters != null) {
            for (Map.Entry headerEntry : headerParameters.entries()) {
                Header header = new Header();
                header.setName((String)headerEntry.getKey());
                Set headerValues = Arrays.stream(((String)headerEntry.getValue()).split(",")).map(String::trim).collect(Collectors.toSet());
                header.setValues(headerValues);
                request.addHeader(header);
            }
        }
    }

    private void completeDispatchCriteriaAndResourcePaths(Operation operation, String rootDispatcher, String rootDispatcherRules, Map<String, Multimap<String, String>> pathParametersByExample, Map<String, Multimap<String, String>> queryParametersByExample, String exampleName, Response response) {
        Object dispatchCriteria = null;
        String resourcePathPattern = operation.getName().split(" ")[1];
        if ("URI_PARAMS".equals(rootDispatcher)) {
            Multimap<String, String> queryParams = queryParametersByExample.get(exampleName);
            dispatchCriteria = DispatchCriteriaHelper.buildFromParamsMap(rootDispatcherRules, queryParams);
            operation.addResourcePath(resourcePathPattern);
        } else if ("URI_PARTS".equals(rootDispatcher)) {
            Multimap<String, String> parts = pathParametersByExample.get(exampleName);
            dispatchCriteria = DispatchCriteriaHelper.buildFromPartsMap(rootDispatcherRules, parts);
            String resourcePath = URIBuilder.buildURIFromPattern(resourcePathPattern, parts);
            operation.addResourcePath(resourcePath);
        } else if ("URI_ELEMENTS".equals(rootDispatcher)) {
            Multimap<String, String> parts = pathParametersByExample.get(exampleName);
            Multimap<String, String> queryParams = queryParametersByExample.get(exampleName);
            dispatchCriteria = DispatchCriteriaHelper.buildFromPartsMap(rootDispatcherRules, parts);
            dispatchCriteria = (String)dispatchCriteria + DispatchCriteriaHelper.buildFromParamsMap(rootDispatcherRules, queryParams);
            String resourcePath = URIBuilder.buildURIFromPattern(resourcePathPattern, parts);
            operation.addResourcePath(resourcePath);
        }
        response.setDispatchCriteria((String)dispatchCriteria);
    }

    private JsonNode getExampleValue(JsonNode example) {
        if (example.has(EXAMPLE_VALUE_NODE)) {
            return this.followRefIfAny(example.path(EXAMPLE_VALUE_NODE));
        }
        if (example.has("$ref")) {
            JsonNode component = this.followRefIfAny(example);
            return this.getExampleValue(component);
        }
        return null;
    }

    private String getSerializedExampleValue(JsonNode example) {
        JsonNode exampleValue = this.getExampleValue(example);
        return exampleValue != null ? this.getValueString(exampleValue) : null;
    }

    private JsonNode getResponseContent(JsonNode response) {
        if (response.has("$ref")) {
            JsonNode component = this.followRefIfAny(response);
            return this.getResponseContent(component);
        }
        return response.path(CONTENT_NODE);
    }

    private String extractOperationParams(JsonNode operation) {
        StringBuilder params = new StringBuilder();
        Iterator parameters = operation.path(PARAMETERS_NODE).elements();
        while (parameters.hasNext()) {
            JsonNode parameter = this.followRefIfAny((JsonNode)parameters.next());
            String parameterIn = parameter.path("in").asText();
            String parameterType = this.followRefIfAny(parameter.path("schema")).path("type").asText();
            if ("path".equals(parameterIn)) continue;
            if (params.length() > 0) {
                params.append(" && ");
            }
            if (parameterType.equals("object")) {
                params.append(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.followRefIfAny(parameter.path("schema")).path("properties").fieldNames(), 16), false).collect(Collectors.joining(" && ")));
                continue;
            }
            params.append(parameter.path("name").asText());
        }
        return params.toString();
    }

    private boolean operationHasParameters(JsonNode operation, String parameterType) {
        if (!operation.has(PARAMETERS_NODE)) {
            return false;
        }
        Iterator parameters = operation.path(PARAMETERS_NODE).elements();
        while (parameters.hasNext()) {
            JsonNode parameter = this.followRefIfAny((JsonNode)parameters.next());
            String parameterIn = parameter.path("in").asText();
            if (!parameterIn.equals(parameterType)) continue;
            return true;
        }
        return false;
    }

    private static boolean urlHasParts(String url) {
        return url.indexOf("/:") != -1 || url.indexOf("/{") != -1;
    }
}

