/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.util.soapui.SoapUIXPathBuilder;
import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.WildcardMatchingAssertion;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XPathContainsAssertion
extends WildcardMatchingAssertion {
    private static Logger log = LoggerFactory.getLogger(XPathContainsAssertion.class);
    public static final String PATH_PARAM = "path";
    public static final String EXPECTED_CONTENT_PARAM = "content";
    private String path;
    private String expectedContent;
    private String errorMessage;

    @Override
    public void configure(Map<String, String> configParams) {
        super.configure(configParams);
        this.path = configParams.get(PATH_PARAM);
        this.expectedContent = configParams.get(EXPECTED_CONTENT_PARAM);
    }

    @Override
    public AssertionStatus assertResponse(RequestResponseExchange exchange, ExchangeContext context) {
        log.debug("Asserting XPath on {}, expecting: {}", (Object)this.path, (Object)this.expectedContent);
        if (this.path == null) {
            this.errorMessage = "Missing path for XPath assertion";
            return AssertionStatus.FAILED;
        }
        if (this.expectedContent == null) {
            this.errorMessage = "Missing content for XPath assertion";
            return AssertionStatus.FAILED;
        }
        try {
            XPathExpression expression = SoapUIXPathBuilder.buildXPathMatcherFromRules(this.path);
            String result = expression.evaluate(new InputSource(new StringReader(exchange.responseContent())));
            if (this.allowWildcards) {
                if (!this.isSimilar(this.expectedContent, result)) {
                    this.errorMessage = "XPathContains comparison failed for path [" + this.path + "], expecting [" + this.expectedContent + "], actual was [" + result + "]";
                    return AssertionStatus.FAILED;
                }
            } else if (!this.expectedContent.equals(result)) {
                this.errorMessage = "XPathContains comparison failed for path [" + this.path + "], expecting [" + this.expectedContent + "], actual was [" + result + "]";
                return AssertionStatus.FAILED;
            }
        }
        catch (XPathExpressionException e) {
            log.warn("Exception while compiling/evaluating XPath", (Throwable)e);
            this.errorMessage = "Exception while compiling/evaluating XPath: " + this.path;
            return AssertionStatus.FAILED;
        }
        return AssertionStatus.VALID;
    }

    @Override
    public List<String> getErrorMessages() {
        return List.of(this.errorMessage);
    }
}

