/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.repository.ResourceRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class DocumentationController {
    private static final Logger log = LoggerFactory.getLogger(DocumentationController.class);
    private static final String RESOURCE_URL = "{RESOURCE_URL}";
    final ResourceRepository resourceRepository;

    public DocumentationController(ResourceRepository resourceRepository) {
        this.resourceRepository = resourceRepository;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GetMapping(value={"/documentation/{name}/{resourceType}"})
    public ResponseEntity<byte[]> getDocumentationByResourceName(@PathVariable(value="name") String name, @PathVariable(value="resourceType") String resourceType) {
        log.info("Requesting {} documentation for resource {}", (Object)resourceType, (Object)name);
        Resource resource = null;
        if (!ResourceType.ASYNC_API_SPEC.toString().equals(resourceType)) return this.responseWithResource("/api/resources/" + name, resourceType, resource);
        List<Resource> resources = this.resourceRepository.findByName(name);
        if (resources.isEmpty()) return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        Optional<Resource> resourceOpt = resources.stream().filter(Resource::isMainArtifact).findFirst();
        if (!resourceOpt.isPresent()) return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        resource = resourceOpt.get();
        return this.responseWithResource("/api/resources/" + name, resourceType, resource);
    }

    @GetMapping(value={"/documentation/id/{id}/{resourceType}"})
    public ResponseEntity<byte[]> getDocumentationByResourceId(@PathVariable(value="id") String id, @PathVariable(value="resourceType") String resourceType) {
        log.info("Requesting {} documentation for resource with id {}", (Object)resourceType, (Object)id);
        Resource resource = null;
        if (ResourceType.ASYNC_API_SPEC.toString().equals(resourceType)) {
            Optional resourceOpt = this.resourceRepository.findById(id);
            if (resourceOpt.isPresent()) {
                resource = (Resource)resourceOpt.get();
            } else {
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        return this.responseWithResource("/api/resources/id/" + id, resourceType, resource);
    }

    private ResponseEntity<byte[]> responseWithResource(String resourceUrl, String resourceType, Resource resource) {
        InputStream stream = null;
        HttpHeaders headers = new HttpHeaders();
        ClassPathResource template = null;
        if (ResourceType.OPEN_API_SPEC.toString().equals(resourceType) || ResourceType.SWAGGER.toString().equals(resourceType)) {
            template = new ClassPathResource("templates/redoc.html");
            headers.setContentType(MediaType.TEXT_HTML);
        } else if (ResourceType.ASYNC_API_SPEC.toString().equals(resourceType)) {
            template = resource.getContent().contains("asyncapi: 3") || resource.getContent().contains("\"asyncapi\": \"3") || resource.getContent().contains("'asyncapi': '3") ? new ClassPathResource("templates/asyncapi-v3.html") : new ClassPathResource("templates/asyncapi.html");
            headers.setContentType(MediaType.TEXT_HTML);
        }
        if (template != null) {
            try {
                stream = template.getInputStream();
            }
            catch (IOException e) {
                log.error("IOException while reading template {}", (Object)template.getDescription(), (Object)e);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringWriter writer = new StringWriter();
            try (Stream<String> lines = reader.lines();){
                lines.map(line -> this.replaceResourceUrlInLing((String)line, resourceUrl)).forEach(line -> writer.write(line + "\n"));
            }
            return new ResponseEntity((Object)writer.toString().getBytes(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private String replaceResourceUrlInLing(String line, String resourceUrl) {
        return line.replace(RESOURCE_URL, resourceUrl);
    }
}

