/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/version"})
@PropertySource(value={"classpath:version.properties"})
public class VersionInfoController {
    private static Logger log = LoggerFactory.getLogger(VersionInfoController.class);
    @Value(value="${versionId}")
    private String versionId = null;
    @Value(value="${buildTimestamp}")
    private String buildTimestamp = null;

    @GetMapping(value={"/info"})
    public ResponseEntity<VersionInfo> getConfig() {
        VersionInfo info = new VersionInfo(this.versionId, this.buildTimestamp);
        log.debug("Returning '{}' version information", (Object)info.getVersionId());
        return new ResponseEntity((Object)info, (HttpStatusCode)HttpStatus.OK);
    }

    private class VersionInfo {
        @JsonProperty(value="versionId")
        private String versionId;
        @JsonProperty(value="buildTimestamp")
        private String buildTimestamp;

        public VersionInfo(String versionId, String buildTimestamp) {
            this.versionId = versionId;
            this.buildTimestamp = buildTimestamp;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public String getBuildTimestamp() {
            return this.buildTimestamp;
        }
    }
}

