/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.ObjectMapperFactory;
import io.github.microcks.util.ReferenceResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonRepositoryImporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractJsonRepositoryImporter.class);
    protected Boolean isYaml;
    protected JsonNode rootSpecification;
    protected String rootSpecificationContent;
    protected ReferenceResolver referenceResolver;
    protected List<Resource> externalResources = new ArrayList<Resource>();
    protected Map<Resource, JsonNode> externalResourcesContent = new HashMap<Resource, JsonNode>();

    protected AbstractJsonRepositoryImporter(String specificationFilePath, ReferenceResolver referenceResolver) throws IOException {
        this.referenceResolver = referenceResolver;
        try (BufferedReader reader = null;){
            String line = null;
            reader = Files.newBufferedReader(new File(specificationFilePath).toPath(), StandardCharsets.UTF_8);
            while ((line = reader.readLine()) != null && this.isYaml == null) {
                if ((line = line.trim()).startsWith("{") || line.startsWith("[")) {
                    this.isYaml = false;
                    continue;
                }
                if (!line.startsWith("---") && !line.startsWith("-") && !line.startsWith("openapi: ") && !line.startsWith("asyncapi: ")) continue;
                this.isYaml = true;
            }
            byte[] bytes = Files.readAllBytes(Paths.get(specificationFilePath, new String[0]));
            this.rootSpecificationContent = new String(bytes, StandardCharsets.UTF_8);
            ObjectMapper mapper = this.getObjectMapper(this.isYaml);
            this.rootSpecification = mapper.readTree(this.rootSpecificationContent.getBytes(StandardCharsets.UTF_8));
        }
    }

    protected void initializeReferencedResources(Service service) throws MockRepositoryImportException {
        if (this.referenceResolver != null) {
            String rootBaseUrl = this.referenceResolver.getBaseRepositoryUrl();
            HashMap<String, Resource> referenceResources = new HashMap<String, Resource>();
            Resource rootResource = new Resource();
            rootResource.setName(service.getName() + "-" + service.getVersion());
            rootResource.setContent(this.rootSpecificationContent);
            referenceResources.put(rootBaseUrl, rootResource);
            this.resolveExternalReferences(service, referenceResources, rootBaseUrl, "", this.rootSpecification);
            this.rootSpecificationContent = rootResource.getContent();
            try {
                ObjectMapper mapper = this.getObjectMapper(this.isYaml);
                this.rootSpecification = mapper.readTree(this.rootSpecificationContent.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                log.error("Exception while parsing re-normalized JSON specification file", (Throwable)e);
                throw new MockRepositoryImportException("Exception while parsing re-normalized JSON specification file");
            }
            this.referenceResolver.cleanResolvedReferences();
        }
    }

    private void resolveExternalReferences(Service service, Map<String, Resource> referenceResources, String baseRepositoryUrl, String baseContext, JsonNode resourceSpecification) {
        Set<String> references = this.findAllExternalRefs(resourceSpecification);
        Resource currentResource = referenceResources.get(baseRepositoryUrl);
        for (String ref : references) {
            this.referenceResolver.setBaseRepositoryUrl(baseRepositoryUrl);
            String refUrl = this.referenceResolver.getReferenceURL(ref);
            Resource referenceResource = referenceResources.get(refUrl);
            if (referenceResource == null) {
                try {
                    String content = this.referenceResolver.getReferenceContent(ref, StandardCharsets.UTF_8);
                    String resourceName = ref.substring(ref.lastIndexOf(47) + 1);
                    String referencePath = ref.contains("/") ? ref.substring(0, ref.lastIndexOf(47)) : ".";
                    String referenceContext = this.buildContext(baseContext, referencePath);
                    resourceName = !ref.startsWith("http") ? IdBuilder.buildResourceFullName((Service)service, (String)resourceName, (String)referenceContext) : IdBuilder.buildResourceFullName((Service)service, (String)resourceName);
                    referenceResource = new Resource();
                    referenceResource.setName(resourceName);
                    referenceResource.setPath(ref);
                    referenceResource.setContent(content);
                    referenceResource.setType(this.guessResourceType(ref, content));
                    referenceResources.put(refUrl, referenceResource);
                    this.externalResources.add(referenceResource);
                    ObjectMapper mapper = this.getObjectMapper(!ref.endsWith(".json"));
                    JsonNode refResourceSpecification = mapper.readTree(content);
                    this.resolveExternalReferences(service, referenceResources, refUrl, referenceContext, refResourceSpecification);
                }
                catch (IOException ioe) {
                    log.error("IOException while trying to resolve reference {}", (Object)ref, (Object)ioe);
                    log.info("Ignoring the reference {} cause it could not be resolved", (Object)ref);
                }
            }
            if (ref.startsWith("http") || referenceResource == null) continue;
            String refNewName = referenceResources.get(refUrl).getName();
            String normalizedContent = currentResource.getContent().replace(ref, URLEncoder.encode(refNewName, StandardCharsets.UTF_8));
            currentResource.setContent(normalizedContent);
        }
    }

    private String buildContext(String baseContext, String referencePath) {
        String result;
        if (".".equals(referencePath)) {
            return baseContext;
        }
        String pathToAppend = referencePath;
        while (pathToAppend.startsWith("../")) {
            if (baseContext.contains("/")) {
                baseContext = baseContext.substring(0, baseContext.lastIndexOf("/"));
            }
            pathToAppend = pathToAppend.substring(3);
        }
        if (pathToAppend.startsWith("./")) {
            pathToAppend = pathToAppend.substring(2);
        }
        if (pathToAppend.startsWith("/")) {
            pathToAppend = pathToAppend.substring(1);
        }
        return (result = baseContext + "/" + pathToAppend).startsWith("/") ? result.substring(1) : result;
    }

    protected JsonNode followRefIfAny(JsonNode referencableNode) {
        if (referencableNode.has("$ref")) {
            String ref = referencableNode.path("$ref").asText();
            return this.getNodeForRef(ref);
        }
        return referencableNode;
    }

    protected String getValueString(JsonNode valueNode) {
        if (valueNode.getNodeType() == JsonNodeType.ARRAY || valueNode.getNodeType() == JsonNodeType.OBJECT) {
            return valueNode.toString();
        }
        return valueNode.asText();
    }

    protected ObjectMapper getObjectMapper(boolean isYaml) {
        return isYaml ? ObjectMapperFactory.getYamlObjectMapper() : ObjectMapperFactory.getJsonObjectMapper();
    }

    private Set<String> findAllExternalRefs(JsonNode node) {
        HashSet<String> externalRefs = new HashSet<String>();
        if (node.has("$ref")) {
            String ref = node.path("$ref").asText();
            if (!ref.startsWith("#")) {
                String filePath = ref;
                if (ref.contains("#/")) {
                    filePath = ref.substring(0, ref.indexOf("#/"));
                }
                externalRefs.add(filePath);
            }
        } else {
            Iterator children = node.elements();
            while (children.hasNext()) {
                externalRefs.addAll(this.findAllExternalRefs((JsonNode)children.next()));
            }
        }
        return externalRefs;
    }

    private JsonNode getNodeForRef(String reference) {
        if (reference.startsWith("#/")) {
            return this.rootSpecification.at(reference.substring(1));
        }
        return this.getNodeForExternalRef(reference);
    }

    private JsonNode getNodeForExternalRef(String externalReference) {
        String path = externalReference;
        String pointerInFile = null;
        if (externalReference.indexOf("#/") != -1) {
            path = externalReference.substring(0, externalReference.indexOf("#/"));
            pointerInFile = externalReference.substring(externalReference.indexOf("#/"));
        }
        for (Resource resource : this.externalResources) {
            if (!path.equals(resource.getPath()) && !path.equals(URLEncoder.encode(resource.getName(), StandardCharsets.UTF_8))) continue;
            JsonNode resourceNode = this.externalResourcesContent.computeIfAbsent(resource, k -> {
                try {
                    return ObjectMapperFactory.getYamlObjectMapper().readTree(resource.getContent());
                }
                catch (JsonProcessingException e) {
                    throw new JsonRepositoryParsingException("Get a JSON processing exception on " + externalReference, e);
                }
            });
            if (pointerInFile != null) {
                return resourceNode.at(pointerInFile.substring(1));
            }
            return resourceNode;
        }
        log.warn("Found no resource for reference {}", (Object)externalReference);
        return null;
    }

    private ResourceType guessResourceType(String ref, String content) {
        if (ref.endsWith(".avsc")) {
            return ResourceType.AVRO_SCHEMA;
        }
        if (ref.endsWith(".proto")) {
            return ResourceType.PROTOBUF_SCHEMA;
        }
        if (content.contains("$schema") || content.contains("properties:") || content.contains("\"properties\":")) {
            return ResourceType.JSON_SCHEMA;
        }
        return ResourceType.JSON_FRAGMENT;
    }

    public class JsonRepositoryParsingException
    extends RuntimeException {
        public JsonRepositoryParsingException(String message) {
            super(message);
        }

        public JsonRepositoryParsingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

