/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.config.ProxySettings;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernamePasswordProxyAuthenticator
extends Authenticator {
    private static Logger log = LoggerFactory.getLogger(UsernamePasswordProxyAuthenticator.class);
    private final ProxySettings settings;
    private final PasswordAuthentication authentication;

    public UsernamePasswordProxyAuthenticator(ProxySettings settings) {
        this.settings = settings;
        this.authentication = new PasswordAuthentication(settings.getUsername(), settings.getPassword().toCharArray());
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        log.debug("Handling proxy authentication for {}", (Object)this.getRequestingHost());
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(this.settings.getHost()) && this.getRequestingPort() == this.settings.getPort().intValue()) {
            return this.authentication;
        }
        return null;
    }
}

