/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import com.google.protobuf.Message;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.grpc.GrpcUtil;
import io.github.microcks.util.grpc.ProtoReflectionService;
import io.github.microcks.web.GrpcServerCallHandler;
import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.stub.ServerCalls;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GrpcMockHandlerRegistry
extends HandlerRegistry {
    private static final Logger log = LoggerFactory.getLogger(GrpcMockHandlerRegistry.class);
    private static final String SERVER_REFLECTION_V1_METHOD = "grpc.reflection.v1.ServerReflection/ServerReflectionInfo";
    private final GrpcServerCallHandler serverCallHandler;
    private final ProtoReflectionService reflectionService;

    public GrpcMockHandlerRegistry(GrpcServerCallHandler serverCallHandler, ServiceRepository serviceRepository, ResourceRepository resourceRepository) {
        this.serverCallHandler = serverCallHandler;
        this.reflectionService = new ProtoReflectionService(serviceRepository, resourceRepository);
    }

    public ProtoReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Nullable
    public ServerMethodDefinition<?, ?> lookupMethod(String fullMethodName, @Nullable String authority) {
        log.debug("lookupMethod() with fullMethodName: {}", (Object)fullMethodName);
        if (SERVER_REFLECTION_V1_METHOD.equals(fullMethodName)) {
            return ServerMethodDefinition.create(this.reflectionMethodDescriptor(), this.reflectionServerCallHandler());
        }
        return ServerMethodDefinition.create(this.mockMethodDescriptor(fullMethodName), this.mockServerCallHandler(fullMethodName));
    }

    protected MethodDescriptor<ServerReflectionRequest, ServerReflectionResponse> reflectionMethodDescriptor() {
        return MethodDescriptor.newBuilder((MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ServerReflectionRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ServerReflectionResponse.getDefaultInstance())).setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(SERVER_REFLECTION_V1_METHOD).setSampledToLocalTracing(true).build();
    }

    protected ServerCallHandler<ServerReflectionRequest, ServerReflectionResponse> reflectionServerCallHandler() {
        return ServerCalls.asyncBidiStreamingCall(this.reflectionService::serverReflectionInfo);
    }

    protected MethodDescriptor<byte[], byte[]> mockMethodDescriptor(String fullMethodName) {
        return GrpcUtil.buildGenericUnaryMethodDescriptor(fullMethodName);
    }

    protected ServerCallHandler<byte[], byte[]> mockServerCallHandler(String fullMethodName) {
        return this.serverCallHandler.getUnaryServerCallHandler(fullMethodName);
    }
}

