/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.XmlSchemaValidator;
import io.github.microcks.util.soap.SoapMessageValidator;
import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaConformanceAssertion
implements SoapUIAssertion {
    private static Logger log = LoggerFactory.getLogger(SchemaConformanceAssertion.class);
    public static final String DEFINITION_PARAM = "definition";
    private String definition;
    private List<String> errorMessages;

    @Override
    public void configure(Map<String, String> configParams) {
        if (configParams.containsKey(DEFINITION_PARAM)) {
            this.definition = configParams.get(DEFINITION_PARAM);
        }
    }

    @Override
    public AssertionStatus assertResponse(RequestResponseExchange exchange, ExchangeContext context) {
        if (context.service().getType() == ServiceType.SOAP_HTTP) {
            log.debug("Asserting Soap response is valid against WSDL");
            Resource wsdl = context.resources().stream().filter(r -> r.getType() == ResourceType.WSDL).findFirst().get();
            QName partQName = new QName(context.service().getXmlNS(), context.operation().getOutputName());
            this.errorMessages = SoapMessageValidator.validateSoapMessage((String)wsdl.getContent(), (QName)partQName, (String)exchange.responseContent(), (String)context.resourceUrl());
            if (!this.errorMessages.isEmpty()) {
                log.debug("Soap response is not valid: {} errors", (Object)this.errorMessages.size());
                return AssertionStatus.FAILED;
            }
        } else if (this.definition != null && exchange.response().getHeaders().getConnection() != null && exchange.response().getHeaders().getConnection().contains("xml")) {
            log.debug("Asserting Xml response is valid against local definition");
            try {
                this.errorMessages = XmlSchemaValidator.validateXml((InputStream)new ByteArrayInputStream(this.definition.getBytes(StandardCharsets.UTF_8)), (String)exchange.responseContent(), (String)context.resourceUrl());
            }
            catch (Exception e) {
                log.warn("Xml schema validation failed with: {}", (Object)e.getMessage());
                this.errorMessages.add("Xml schema validation failed with: " + e.getMessage());
            }
            if (!this.errorMessages.isEmpty()) {
                log.debug("Xml response is not valid according definition: {} errors", (Object)this.errorMessages.size());
                return AssertionStatus.FAILED;
            }
        }
        return AssertionStatus.VALID;
    }

    @Override
    public List<String> getErrorMessages() {
        return this.errorMessages;
    }
}

