/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.service.ImportExportService;
import io.github.microcks.util.SafeLogger;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ExportController {
    private static final SafeLogger log = SafeLogger.getLogger(ExportController.class);
    private final ImportExportService importExportService;

    public ExportController(ImportExportService importExportService) {
        this.importExportService = importExportService;
    }

    @GetMapping(value={"/export"})
    public ResponseEntity<Object> exportRepository(@RequestParam(value="serviceIds") List<String> serviceIds) {
        log.debug("Extracting export for serviceIds {}", (Object)serviceIds);
        String json = this.importExportService.exportRepository(serviceIds, "json");
        byte[] body = json.getBytes();
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_JSON);
        responseHeaders.set("Content-Disposition", "attachment; filename=microcks-repository.json");
        responseHeaders.setContentLength((long)body.length);
        return new ResponseEntity((Object)body, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }
}

