/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.GenericResource;
import io.github.microcks.repository.GenericResourceRepository;
import io.github.microcks.util.SafeLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class GenericResourceController {
    private static final SafeLogger log = SafeLogger.getLogger(GenericResourceController.class);
    public static final String ID_FIELD = "id";
    private final GenericResourceRepository genericResourceRepository;

    public GenericResourceController(GenericResourceRepository genericResourceRepository) {
        this.genericResourceRepository = genericResourceRepository;
    }

    @GetMapping(value={"/genericresources/service/{serviceId}"})
    public List<GenericResource> listResources(@PathVariable(value="serviceId") String serviceId, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="10") int size) {
        log.debug("List resources for service '{}'", (Object)serviceId);
        List<GenericResource> genericResources = this.genericResourceRepository.findByServiceId(serviceId, (Pageable)PageRequest.of((int)page, (int)size));
        return genericResources.stream().map(this::addIdToPayload).toList();
    }

    @GetMapping(value={"/genericresources/service/{serviceId}/count"})
    public Map<String, Long> countResources(@PathVariable(value="serviceId") String serviceId) {
        log.debug("Counting resources for service '{}'", (Object)serviceId);
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.genericResourceRepository.countByServiceId(serviceId));
        return counter;
    }

    private GenericResource addIdToPayload(GenericResource genericResource) {
        Document document = genericResource.getPayload();
        document.append(ID_FIELD, (Object)genericResource.getId());
        return genericResource;
    }
}

