/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.repository.ImportJobRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class HealthController {
    private static final Logger log = LoggerFactory.getLogger(HealthController.class);
    private final ImportJobRepository jobRepository;

    public HealthController(ImportJobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    @GetMapping(value={"/health"})
    public ResponseEntity<String> health() {
        log.trace("Health check endpoint invoked");
        try {
            this.jobRepository.findAll((Pageable)PageRequest.of((int)0, (int)10, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}))).getContent();
        }
        catch (Exception e) {
            log.error("Health check caught an exception: {}", (Object)e.getMessage(), (Object)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        log.trace("Health check is OK");
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

