/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.service.ImportExportService;
import io.github.microcks.util.SafeLogger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class ImportController {
    private static final SafeLogger log = SafeLogger.getLogger(ImportController.class);
    private final ImportExportService importExportService;

    public ImportController(ImportExportService importExportService) {
        this.importExportService = importExportService;
    }

    @PostMapping(value={"/import"})
    public ResponseEntity<byte[]> importRepository(@RequestParam(value="file") MultipartFile file) {
        log.debug("Importing new services and resources definitions");
        if (!file.isEmpty()) {
            log.debug("Content type of {} is {}", (Object)file.getOriginalFilename(), (Object)file.getContentType());
            if ("application/json".equals(file.getContentType())) {
                try {
                    byte[] bytes = file.getBytes();
                    String json = new String(bytes);
                    this.importExportService.importRepository(json);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
    }
}

