/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.ImportJob;
import io.github.microcks.domain.Metadata;
import io.github.microcks.repository.ImportJobRepository;
import io.github.microcks.security.AuthorizationChecker;
import io.github.microcks.security.UserInfo;
import io.github.microcks.service.JobService;
import io.github.microcks.util.SafeLogger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class JobController {
    private static final SafeLogger log = SafeLogger.getLogger(JobController.class);
    private final ImportJobRepository jobRepository;
    private final JobService jobService;
    private final AuthorizationChecker authorizationChecker;

    public JobController(ImportJobRepository jobRepository, JobService jobService, AuthorizationChecker authorizationChecker) {
        this.jobRepository = jobRepository;
        this.jobService = jobService;
        this.authorizationChecker = authorizationChecker;
    }

    @GetMapping(value={"/jobs"})
    public List<ImportJob> listJobs(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="20") int size, @RequestParam(value="name", required=false) String name) {
        log.debug("Getting job list for page {} and size {}", (Object)page, (Object)size);
        if (name != null) {
            return this.jobRepository.findByNameLike(name);
        }
        return this.jobRepository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}))).getContent();
    }

    @GetMapping(value={"/jobs/search"})
    public List<ImportJob> searchJobs(@RequestParam Map<String, String> queryMap) {
        String name = null;
        HashMap<String, String> labels = new HashMap<String, String>();
        for (Map.Entry<String, String> paramEntry : queryMap.entrySet()) {
            String paramKey = paramEntry.getKey();
            if ("name".equals(paramKey)) {
                name = paramEntry.getValue();
            }
            if (!paramKey.startsWith("labels.")) continue;
            labels.put(paramKey.substring(paramKey.indexOf(46) + 1), paramEntry.getValue());
        }
        if (labels.isEmpty()) {
            log.debug("Searching jobs corresponding to name {}", (Object)name);
            return this.jobRepository.findByNameLike(name);
        }
        if (name == null || name.trim().isEmpty()) {
            log.debug("Searching jobs corresponding to labels {}", (Object)labels);
            return this.jobRepository.findByLabels(labels);
        }
        log.debug("Searching jobs corresponding to name {} and labels {}", (Object)name, (Object)labels);
        return this.jobRepository.findByLabelsAndNameLike(labels, name);
    }

    @GetMapping(value={"/jobs/count"})
    public Map<String, Long> countJobs() {
        log.debug("Counting jobs...");
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.jobRepository.count());
        return counter;
    }

    @PostMapping(value={"/jobs"})
    public ResponseEntity<ImportJob> createJob(@RequestBody ImportJob job) {
        log.debug("Creating new job: {}", (Object)job);
        Map labels = null;
        if (job.getMetadata() != null && job.getMetadata().getLabels() != null) {
            labels = job.getMetadata().getLabels();
        }
        job.setMetadata(new Metadata());
        job.setCreatedDate(new Date());
        if (labels != null) {
            job.getMetadata().setLabels(labels);
        }
        return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/jobs/{id}"})
    public ResponseEntity<ImportJob> getJob(@PathVariable(value="id") String jobId) {
        log.debug("Retrieving job with id {}", (Object)jobId);
        return new ResponseEntity((Object)this.jobRepository.findById(jobId).orElse(null), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/jobs/{id}"})
    public ResponseEntity<ImportJob> saveJob(@RequestBody ImportJob job, UserInfo userInfo) {
        log.debug("Saving existing job: {}", (Object)job);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            this.initMetadataIfMissing(job);
            job.getMetadata().objectUpdated();
            return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @PutMapping(value={"/jobs/{id}/activate"})
    public ResponseEntity<ImportJob> activateJob(@PathVariable(value="id") String jobId, UserInfo userInfo) {
        log.debug("Activating job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            job.setActive(true);
            this.initMetadataIfMissing(job);
            job.getMetadata().objectUpdated();
            return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @PutMapping(value={"/jobs/{id}/start"})
    public ResponseEntity<ImportJob> startJob(@PathVariable(value="id") String jobId, UserInfo userInfo) {
        log.debug("Starting job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            job.setActive(true);
            this.initMetadataIfMissing(job);
            job.getMetadata().objectUpdated();
            this.jobService.doImportJob(job);
            return new ResponseEntity((Object)job, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @PutMapping(value={"/jobs/{id}/stop"})
    public ResponseEntity<ImportJob> stopJob(@PathVariable(value="id") String jobId, UserInfo userInfo) {
        log.debug("Stopping job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            job.setActive(false);
            this.initMetadataIfMissing(job);
            job.getMetadata().objectUpdated();
            return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @DeleteMapping(value={"/jobs/{id}"})
    public ResponseEntity<String> deleteJob(@PathVariable(value="id") String jobId, UserInfo userInfo) {
        log.debug("Removing job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForImportJob(userInfo, "manager", job)) {
            this.jobRepository.deleteById(jobId);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    private void initMetadataIfMissing(ImportJob job) {
        if (job.getMetadata() == null) {
            job.setMetadata(new Metadata());
        }
    }
}

