/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.repository.ServiceStateRepository;
import io.github.microcks.service.ProxyService;
import io.github.microcks.service.ServiceStateStore;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.SafeLogger;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.dispatcher.ProxyFallbackSpecification;
import io.github.microcks.util.script.ScriptEngineBinder;
import io.github.microcks.util.soap.SoapMessageValidator;
import io.github.microcks.util.soapui.SoapUIXPathBuilder;
import io.github.microcks.web.DispatchContext;
import io.github.microcks.web.MockControllerCommons;
import jakarta.servlet.http.HttpServletRequest;
import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpression;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.xml.sax.InputSource;

@RestController
@RequestMapping(value={"/soap"})
public class SoapController {
    private static final SafeLogger log = SafeLogger.getLogger(SoapController.class);
    private static final Pattern OPERATION_CAPTURE_PATTERN = Pattern.compile("(.*):Body>(\\s*)<((\\w+):|)(?<operation>\\w+)(.*)(/)?>(.*)", 32);
    private static final Pattern SOAPUI_TEMPLATE_PARAMETER_REPLACE_PATTERN = Pattern.compile("\\$\\{ *([a-zA-Z0-9-_]+) *\\}", 32);
    private final ServiceRepository serviceRepository;
    private final ServiceStateRepository serviceStateRepository;
    private final ResponseRepository responseRepository;
    private final ResourceRepository resourceRepository;
    private final ApplicationContext applicationContext;
    private final ProxyService proxyService;
    @Value(value="${mocks.enable-invocation-stats}")
    private Boolean enableInvocationStats;
    @Value(value="${validation.resourceUrl}")
    private String resourceUrl;

    public SoapController(ServiceRepository serviceRepository, ServiceStateRepository serviceStateRepository, ResponseRepository responseRepository, ResourceRepository resourceRepository, ApplicationContext applicationContext, ProxyService proxyService) {
        this.serviceRepository = serviceRepository;
        this.serviceStateRepository = serviceStateRepository;
        this.responseRepository = responseRepository;
        this.resourceRepository = resourceRepository;
        this.applicationContext = applicationContext;
        this.proxyService = proxyService;
    }

    @PostMapping(value={"/{service}/{version}/**"})
    public ResponseEntity<?> execute(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @RequestParam(value="validate", required=false) Boolean validate, @RequestParam(value="delay", required=false) Long delay, @RequestBody String body, @RequestHeader HttpHeaders headers, HttpServletRequest request, HttpMethod method) {
        log.info("Servicing mock response for service [{}, {}]", (Object)serviceName, (Object)version);
        log.debug("Request body: {}", (Object)body);
        long startTime = System.currentTimeMillis();
        String serviceAndVersion = MockControllerCommons.composeServiceAndVersion(serviceName, version);
        if (serviceName.contains("+")) {
            serviceName = serviceName.replace('+', ' ');
        }
        log.debug("Service name: {}", (Object)serviceName);
        Service service = this.serviceRepository.findByNameAndVersion(serviceName, version);
        if (service == null) {
            return new ResponseEntity((Object)String.format("The service %s with version %s does not exist!", serviceName, version), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Operation rOperation = null;
        String action = this.extractSoapAction(request);
        log.debug("Extracted SOAP action from headers: {}", (Object)action);
        if (StringUtils.hasText((String)action)) {
            for (Object operation : service.getOperations()) {
                if (!action.equals(operation.getAction())) continue;
                rOperation = operation;
                log.info("Found valid operation {}", (Object)rOperation.getName());
                break;
            }
        }
        if (rOperation == null) {
            String operationName = SoapController.extractOperationName(body);
            if (!StringUtils.hasText((String)action)) {
                action = operationName;
            }
            log.debug("Extracted operation name from payload: {}", (Object)operationName);
            if (operationName != null) {
                for (Operation operation : service.getOperations()) {
                    if (!operationName.equals(operation.getInputName()) && !operationName.equals(operation.getName())) continue;
                    rOperation = operation;
                    log.debug("Found valid operation {}", (Object)rOperation.getName());
                    break;
                }
            }
        }
        if (rOperation != null) {
            Optional<URI> proxyUrl;
            DispatchContext dispatchContext;
            Response response;
            ProxyFallbackSpecification proxyFallback;
            FallbackSpecification fallback;
            String dispatcherRules;
            String dispatcher;
            block28: {
                log.debug("Found a valid operation with rules: {}", (Object)rOperation.getDispatcherRules());
                if (validate != null && validate.booleanValue()) {
                    log.debug("Soap message validation is turned on, validating...");
                    List<Resource> wsdlResources = this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.WSDL);
                    if (wsdlResources.isEmpty()) {
                        return new ResponseEntity((Object)String.format("The service %s with version %s does not have a wsdl!", serviceName, version), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
                    }
                    Resource wsdlResource = wsdlResources.get(0);
                    List errors = SoapMessageValidator.validateSoapMessage((String)wsdlResource.getContent(), (QName)new QName(service.getXmlNS(), rOperation.getInputName()), (String)body, (String)this.resourceUrl);
                    log.debug("SoapBody validation errors: {}", (Object)errors.size());
                    if (errors != null && !errors.isEmpty()) {
                        return new ResponseEntity((Object)errors, (HttpStatusCode)HttpStatus.BAD_REQUEST);
                    }
                }
                dispatcher = rOperation.getDispatcher();
                dispatcherRules = rOperation.getDispatcherRules();
                fallback = MockControllerCommons.getFallbackIfAny(rOperation);
                if (fallback != null) {
                    dispatcher = fallback.getDispatcher();
                    dispatcherRules = fallback.getDispatcherRules();
                }
                if ((proxyFallback = MockControllerCommons.getProxyFallbackIfAny(rOperation)) != null) {
                    dispatcher = proxyFallback.getDispatcher();
                    dispatcherRules = proxyFallback.getDispatcherRules();
                }
                response = null;
                dispatchContext = null;
                try {
                    if ("QUERY_MATCH".equals(dispatcher)) {
                        dispatchContext = this.getDispatchCriteriaFromXPathEval(dispatcherRules, body);
                        break block28;
                    }
                    if ("SCRIPT".equals(dispatcher)) {
                        dispatchContext = this.getDispatchCriteriaFromScriptEval(service, dispatcherRules, body, request);
                        break block28;
                    }
                    if ("RANDOM".equals(dispatcher)) {
                        dispatchContext = new DispatchContext("RANDOM", null);
                        break block28;
                    }
                    if ("PROXY".equals(dispatcher)) {
                        dispatchContext = new DispatchContext("PROXY", null);
                        break block28;
                    }
                    return new ResponseEntity((Object)String.format("The dispatch %s is not supported!", dispatcher), (HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                catch (ResponseStatusException e) {
                    return new ResponseEntity((Object)e.getMessage(), e.getStatusCode());
                }
            }
            log.debug("Dispatch criteria for finding response is {}", (Object)dispatchContext.dispatchCriteria());
            List<Response> responses = this.responseRepository.findByOperationIdAndDispatchCriteria(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), dispatchContext.dispatchCriteria());
            if (responses.isEmpty() && fallback != null) {
                responses = this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), fallback.getFallback());
            }
            if ((proxyUrl = MockControllerCommons.getProxyUrlIfProxyIsNeeded(dispatcher, dispatcherRules, MockControllerCommons.extractResourcePath(request, serviceAndVersion), proxyFallback, request, responses.isEmpty() ? null : responses.get(0))).isPresent()) {
                return this.proxyService.callExternal(proxyUrl.get(), method, headers, body);
            }
            if (responses.isEmpty()) {
                return new ResponseEntity((Object)String.format("The response %s does not exist!", dispatchContext.dispatchCriteria()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            int idx = "RANDOM".equals(dispatcher) ? RandomUtils.nextInt((int)0, (int)responses.size()) : 0;
            response = responses.get(idx);
            HttpHeaders responseHeaders = new HttpHeaders();
            if (request.getContentType().startsWith("application/soap+xml")) {
                responseHeaders.setContentType(MediaType.valueOf((String)"application/soap+xml;charset=UTF-8"));
            } else {
                responseHeaders.setContentType(MediaType.valueOf((String)"text/xml;charset=UTF-8"));
            }
            response.setContent(SoapController.convertSoapUITemplate(response.getContent()));
            String responseContent = MockControllerCommons.renderResponseContent(body, null, request, dispatchContext.requestContext(), response);
            if (delay == null && rOperation.getDefaultDelay() != null) {
                delay = rOperation.getDefaultDelay();
            }
            MockControllerCommons.waitForDelay(startTime, delay);
            if (Boolean.TRUE.equals(this.enableInvocationStats)) {
                MockControllerCommons.publishMockInvocation(this.applicationContext, this, service, response, startTime);
            }
            if (response.isFault()) {
                return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)String.format("The operation %s does not exist!", action), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    protected static boolean hasPayloadCorrectStructureForOperation(String payload, String operationName) {
        String openingPattern = "(.*):Body>(\\s*)<((\\w+):|)" + operationName + "(.*)>(.*)";
        String closingPattern = "(.*)</((\\w+):|)" + operationName + ">(\\s*)</(.*):Body>(.*)";
        String shortPattern = "(.*):Body>(\\s*)<((\\w+):|)" + operationName + "(.*)/>(\\s*)</(.*):Body>(.*)";
        Pattern op = Pattern.compile(openingPattern, 32);
        Pattern cp = Pattern.compile(closingPattern, 32);
        Pattern sp = Pattern.compile(shortPattern, 32);
        return op.matcher(payload).matches() && cp.matcher(payload).matches() || sp.matcher(payload).matches();
    }

    protected static String extractOperationName(String payload) {
        Matcher matcher = OPERATION_CAPTURE_PATTERN.matcher(payload);
        if (matcher.find()) {
            return matcher.group("operation");
        }
        return null;
    }

    protected String extractSoapAction(HttpServletRequest request) {
        String action = null;
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("application/soap+xml") && contentType.contains("action=")) {
            action = contentType.substring(contentType.indexOf("action=") + 7);
            if (action.contains(";")) {
                action = action.substring(0, action.indexOf(";"));
            }
        } else {
            action = request.getHeader("SOAPAction");
        }
        if (action != null) {
            if (action.startsWith("\"")) {
                action = action.substring(1);
            }
            if (action.endsWith("\"")) {
                action = action.substring(0, action.length() - 1);
            }
        }
        return action;
    }

    private DispatchContext getDispatchCriteriaFromXPathEval(String dispatcherRules, String body) {
        try {
            XPathExpression xpath = SoapUIXPathBuilder.buildXPathMatcherFromRules(dispatcherRules);
            return new DispatchContext(xpath.evaluate(new InputSource(new StringReader(body))), null);
        }
        catch (Exception e) {
            log.error("Error during Xpath evaluation", e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error during Xpath evaluation: " + e.getMessage());
        }
    }

    private DispatchContext getDispatchCriteriaFromScriptEval(Service service, String dispatcherRules, String body, HttpServletRequest request) {
        ScriptEngineManager sem = new ScriptEngineManager();
        HashMap<String, Object> requestContext = new HashMap<String, Object>();
        try {
            ScriptEngine se = sem.getEngineByExtension("groovy");
            ScriptEngineBinder.bindEnvironment(se, body, requestContext, new ServiceStateStore(this.serviceStateRepository, service.getId()), request);
            String script = ScriptEngineBinder.ensureSoapUICompatibility(dispatcherRules);
            return new DispatchContext((String)se.eval(script), requestContext);
        }
        catch (Exception e) {
            log.error("Error during Script evaluation", e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error during Script evaluation: " + e.getMessage());
        }
    }

    protected static String convertSoapUITemplate(String responseTemplate) {
        if (responseTemplate.contains("${")) {
            return SOAPUI_TEMPLATE_PARAMETER_REPLACE_PATTERN.matcher(responseTemplate).replaceAll("{{ $1 }}");
        }
        return responseTemplate;
    }
}

