/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import io.github.microcks.util.grpc.GrpcMockHandlerRegistry;
import io.grpc.Grpc;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.TlsServerCredentials;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GrpcServerStarter {
    private static Logger log = LoggerFactory.getLogger(GrpcServerStarter.class);
    @Value(value="${grpc.server.port:9090}")
    private final Integer serverPort = 9090;
    @Value(value="${grpc.server.certChainFilePath:}")
    private final String certChainFilePath;
    @Value(value="${grpc.server.privateKeyFilePath:}")
    private final String privateKeyFilePath;
    @Autowired
    private GrpcMockHandlerRegistry mockHandlerRegistry;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private CountDownLatch latch;

    public GrpcServerStarter() {
        this.certChainFilePath = null;
        this.privateKeyFilePath = null;
    }

    @PostConstruct
    public void startGrpcServer() {
        try {
            this.latch = new CountDownLatch(1);
            Server grpcServer = null;
            if (this.certChainFilePath != null && this.certChainFilePath.length() > 0 && this.privateKeyFilePath != null && this.privateKeyFilePath.length() > 0) {
                TlsServerCredentials.Builder tlsBuilder = TlsServerCredentials.newBuilder().keyManager(new File(this.certChainFilePath), new File(this.privateKeyFilePath));
                grpcServer = Grpc.newServerBuilderForPort((int)this.serverPort, (ServerCredentials)tlsBuilder.build()).fallbackHandlerRegistry((HandlerRegistry)this.mockHandlerRegistry).build();
            } else {
                grpcServer = ServerBuilder.forPort((int)this.serverPort).fallbackHandlerRegistry((HandlerRegistry)this.mockHandlerRegistry).build();
            }
            grpcServer.start();
            log.info("GRPC Server started on port " + this.serverPort);
            final Server finalGrpcServer = grpcServer;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        if (finalGrpcServer != null) {
                            log.info("Shutting down gRPC server since JVM is shutting down");
                            finalGrpcServer.shutdown().awaitTermination(2L, TimeUnit.SECONDS);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.startDaemonAwaitThread();
        }
        catch (Exception e) {
            log.error("GRPC Server cannot be started", (Throwable)e);
        }
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread(() -> {
            try {
                this.isRunning.set(true);
                this.latch.await();
            }
            catch (InterruptedException e) {
                log.error("GRPC Server awaiter interrupted.", (Throwable)e);
            }
            finally {
                this.isRunning.set(false);
            }
        });
        awaitThread.setName("grpc-server-awaiter");
        awaitThread.setDaemon(false);
        awaitThread.start();
    }
}

