/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Service;
import io.github.microcks.service.ArtifactInfo;
import io.github.microcks.service.ServiceService;
import io.github.microcks.util.HTTPDownloader;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.ReferenceResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class UploadArtifactController {
    private static Logger log = LoggerFactory.getLogger(UploadArtifactController.class);
    @Autowired
    private ServiceService serviceService;

    @RequestMapping(value={"/artifact/download"}, method={RequestMethod.POST})
    public ResponseEntity<?> importArtifact(@RequestParam(value="url", required=true) String url) {
        if (!url.isEmpty()) {
            List<Service> services = null;
            try {
                File localFile = HTTPDownloader.handleHTTPDownloadToFile(url, null, true);
                services = this.serviceService.importServiceDefinition(localFile, new ReferenceResolver(url, null, true), new ArtifactInfo(url, true));
            }
            catch (IOException ioe) {
                log.error("Exception while retrieving remote item " + url, (Throwable)ioe);
                return new ResponseEntity((Object)"Exception while retrieving remote item", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (MockRepositoryImportException mrie) {
                return new ResponseEntity((Object)mrie.getMessage(), HttpStatus.BAD_REQUEST);
            }
            if (services != null && services.size() > 0) {
                return new ResponseEntity((Object)(services.get(0).getName() + ":" + services.get(0).getVersion()), HttpStatus.CREATED);
            }
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/artifact/upload"}, method={RequestMethod.POST})
    public ResponseEntity<?> importArtifact(@RequestParam(value="file") MultipartFile file, @RequestParam(value="mainArtifact", defaultValue="true") boolean mainArtifact) {
        if (!file.isEmpty()) {
            log.debug("Content type of " + file.getOriginalFilename() + " is " + file.getContentType());
            List<Service> services = null;
            try {
                String localFile = System.getProperty("java.io.tmpdir") + "/microcks-" + System.currentTimeMillis() + ".artifact";
                ReadableByteChannel rbc = null;
                FileOutputStream fos = null;
                try {
                    rbc = Channels.newChannel(file.getInputStream());
                    fos = new FileOutputStream(localFile);
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                    if (rbc != null) {
                        rbc.close();
                    }
                }
                services = this.serviceService.importServiceDefinition(new File(localFile), null, new ArtifactInfo(file.getOriginalFilename(), mainArtifact));
            }
            catch (IOException ioe) {
                log.error("Exception while writing uploaded item " + file.getOriginalFilename(), (Throwable)ioe);
                return new ResponseEntity((Object)"Exception while writing uploaded item", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (MockRepositoryImportException mrie) {
                return new ResponseEntity((Object)mrie.getMessage(), HttpStatus.BAD_REQUEST);
            }
            if (services != null && services.size() > 0) {
                return new ResponseEntity((Object)(services.get(0).getName() + ":" + services.get(0).getVersion()), HttpStatus.CREATED);
            }
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

