/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.listener;

import io.github.microcks.domain.DailyStatistic;
import io.github.microcks.event.MockInvocationEvent;
import io.github.microcks.repository.DailyStatisticRepository;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DailyStatisticsFeeder
implements ApplicationListener<MockInvocationEvent> {
    private static Log log = LogFactory.getLog(DailyStatisticsFeeder.class);
    @Autowired
    private DailyStatisticRepository statisticsRepository;

    @Async
    public void onApplicationEvent(MockInvocationEvent event) {
        log.debug((Object)("Received a MockInvocationEvent on " + event.getServiceName() + " - v" + event.getServiceVersion()));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(event.getInvocationTimestamp());
        int month = calendar.get(2) + 1;
        String monthStr = (month < 10 ? "0" : "") + String.valueOf(month);
        int dayOfMonth = calendar.get(5);
        String dayOfMonthStr = (dayOfMonth < 10 ? "0" : "") + String.valueOf(dayOfMonth);
        String day = String.valueOf(calendar.get(1)) + monthStr + dayOfMonthStr;
        String hourKey = String.valueOf(calendar.get(11));
        String minuteKey = String.valueOf(60 * calendar.get(11) + calendar.get(12));
        if (log.isDebugEnabled()) {
            log.debug((Object)("hourKey for statistic is " + hourKey));
            log.debug((Object)("minuteKey for statistic is " + minuteKey));
        }
        DailyStatistic statistic = null;
        List<DailyStatistic> statistics = this.statisticsRepository.findByDayAndServiceNameAndServiceVersion(day, event.getServiceName(), event.getServiceVersion());
        if (!statistics.isEmpty()) {
            statistic = statistics.get(0);
        }
        if (statistic == null) {
            log.debug((Object)("There's no statistics for " + day + " yet. Create one...."));
            statistic = new DailyStatistic();
            statistic.setDay(day);
            statistic.setServiceName(event.getServiceName());
            statistic.setServiceVersion(event.getServiceVersion());
            statistic.setHourlyCount(this.initializeHourlyMap());
            statistic.setMinuteCount(this.initializeMinuteMap());
            statistic.setDailyCount(1L);
            statistic.getHourlyCount().put(hourKey, 1);
            statistic.getMinuteCount().put(minuteKey, 1);
            this.statisticsRepository.save(statistic);
        } else {
            log.debug((Object)("Found an existing statistic document for " + day));
            this.statisticsRepository.incrementDailyStatistic(day, event.getServiceName(), event.getServiceVersion(), hourKey, minuteKey);
        }
        log.debug((Object)"Processing of MockInvocationEvent done !");
    }

    private Map<String, Integer> initializeHourlyMap() {
        HashMap<String, Integer> result = new HashMap<String, Integer>(24);
        for (int i = 0; i < 24; ++i) {
            result.put(String.valueOf(i), 0);
        }
        return result;
    }

    private Map<String, Integer> initializeMinuteMap() {
        HashMap<String, Integer> result = new HashMap<String, Integer>(1440);
        for (int i = 0; i < 1440; ++i) {
            result.put(String.valueOf(i), 0);
        }
        return result;
    }
}

