/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.security;

import io.github.microcks.domain.ImportJob;
import io.github.microcks.domain.Service;
import io.github.microcks.security.UserInfo;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.stereotype.Component;

@Component
@PropertySources(value={@PropertySource(value={"features.properties"}), @PropertySource(value={"file:/deployments/config/features.properties"}, ignoreResourceNotFound=true), @PropertySource(value={"application.properties"})})
public class AuthorizationChecker {
    public static final String ROLE_USER = "user";
    public static final String ROLE_MANAGER = "manager";
    public static final String ROLE_ADMIN = "admin";
    private static final String MICROCKS_GROUPS_PREFIX = "/microcks/";
    @Value(value="${keycloak.enabled}")
    private final Boolean authenticationEnabled = true;
    @Value(value="${features.feature.repository-tenancy.enabled}")
    private final Boolean authorizationEnabled = false;
    @Value(value="${features.feature.repository-filter.label-key}")
    private final String filterLabelKey;

    public AuthorizationChecker() {
        this.filterLabelKey = null;
    }

    public boolean hasRole(UserInfo userInfo, String role) {
        if (this.authenticationEnabled.booleanValue()) {
            return Arrays.stream(userInfo.getRoles()).anyMatch(role::equals);
        }
        return true;
    }

    public boolean hasRoleForService(UserInfo userInfo, String role, Service service) {
        if (this.authorizationEnabled.booleanValue() && service.getMetadata().getLabels() != null) {
            String rolePath = MICROCKS_GROUPS_PREFIX + role + "/" + (String)service.getMetadata().getLabels().get(this.filterLabelKey);
            boolean serviceRole = Arrays.stream(userInfo.getGroups()).anyMatch(rolePath::equals);
            return serviceRole || this.hasRole(userInfo, role);
        }
        return this.hasRole(userInfo, role);
    }

    public boolean hasRoleForImportJob(UserInfo userInfo, String role, ImportJob job) {
        if (this.authorizationEnabled.booleanValue() && job.getMetadata().getLabels() != null) {
            String rolePath = MICROCKS_GROUPS_PREFIX + role + "/" + (String)job.getMetadata().getLabels().get(this.filterLabelKey);
            boolean jobRole = Arrays.stream(userInfo.getGroups()).anyMatch(rolePath::equals);
            return jobRole || this.hasRole(userInfo, role);
        }
        return this.hasRole(userInfo, role);
    }
}

