/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ServiceRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ResourceController {
    private static Logger log = LoggerFactory.getLogger(ResourceController.class);
    private static final String SWAGGER_20 = "swagger_20";
    private static final String OPENAPI_30 = "openapi_30";
    private static final String SERVICE_PATTERN = "\\{service\\}";
    private static final String VERSION_PATTERN = "\\{version\\}";
    private static final String RESOURCE_PATTERN = "\\{resource\\}";
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private ServiceRepository serviceRepository;

    @RequestMapping(value={"/resources/{name}"}, method={RequestMethod.GET})
    public ResponseEntity<?> execute(@PathVariable(value="name") String name, HttpServletRequest request) {
        String extension = request.getRequestURI().substring(request.getRequestURI().lastIndexOf(46));
        try {
            name = URLDecoder.decode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error("Exception while decoding resource name: {}", (Object)e.getMessage());
        }
        log.info("Requesting resource named " + name);
        Resource resource = this.resourceRepository.findByName(name);
        if (resource != null) {
            HttpHeaders headers = new HttpHeaders();
            if (".json".equals(extension)) {
                headers.setContentType(MediaType.APPLICATION_JSON);
            } else if (".yaml".equals(extension) || ".yml".equals(extension)) {
                headers.set("Content-Type", "text/yaml");
                headers.setContentDisposition(ContentDisposition.builder((String)"inline").filename(name).build());
            } else if (".wsdl".equals(extension) || ".xsd".equals(extension)) {
                headers.setContentType(MediaType.TEXT_XML);
            } else if (".avsc".equals(extension)) {
                headers.setContentType(MediaType.APPLICATION_JSON);
            }
            return new ResponseEntity((Object)resource.getContent(), (MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/resources/service/{serviceId}"}, method={RequestMethod.GET})
    public List<Resource> getServiceResources(@PathVariable(value="serviceId") String serviceId) {
        log.debug("Request resources for service {}", (Object)serviceId);
        return this.resourceRepository.findByServiceId(serviceId);
    }

    @RequestMapping(value={"/resources/{serviceId}/{resourceType}"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getServiceResource(@PathVariable(value="serviceId") String serviceId, @PathVariable(value="resourceType") String resourceType, HttpServletResponse response) {
        log.info("Requesting {} resource for service {}", (Object)resourceType, (Object)serviceId);
        Service service = this.serviceRepository.findById(serviceId).orElse(null);
        if (service != null && ServiceType.GENERIC_REST.equals((Object)service.getType())) {
            ClassPathResource template;
            InputStream stream = null;
            String resource = this.findResource(service);
            HttpHeaders headers = new HttpHeaders();
            if (SWAGGER_20.equals(resourceType)) {
                template = new ClassPathResource("templates/swagger-2.0.json");
                try {
                    stream = template.getInputStream();
                }
                catch (IOException e) {
                    log.error("IOException while reading swagger-2.0.json template", (Throwable)e);
                }
                headers.setContentType(MediaType.APPLICATION_JSON);
            } else if (OPENAPI_30.equals(resourceType)) {
                template = new ClassPathResource("templates/openapi-3.0.yaml");
                try {
                    stream = template.getInputStream();
                }
                catch (IOException e) {
                    log.error("IOException while reading openapi-3.0.yaml template", (Throwable)e);
                }
                headers.set("Content-Type", "text/yaml");
            }
            if (stream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                StringWriter writer = new StringWriter();
                try (Stream<String> lines = reader.lines();){
                    lines.map(line -> this.replaceInLine((String)line, service, resource)).forEach(line -> writer.write(line + "\n"));
                }
                return new ResponseEntity((Object)writer.toString().getBytes(), (MultiValueMap)headers, HttpStatus.OK);
            }
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    private String findResource(Service service) {
        for (Operation operation : service.getOperations()) {
            if (!operation.getName().startsWith("GET /") || operation.getName().endsWith("/:id")) continue;
            return operation.getName().substring("GET /".length());
        }
        return null;
    }

    private String replaceInLine(String line, Service service, String resource) {
        line = line.replaceAll(SERVICE_PATTERN, service.getName());
        line = line.replaceAll(VERSION_PATTERN, service.getVersion());
        line = line.replaceAll(RESOURCE_PATTERN, resource);
        return line;
    }
}

