/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.dispatcher.JsonEvaluationSpecification;
import io.github.microcks.util.dispatcher.JsonExpressionEvaluator;
import io.github.microcks.util.dispatcher.JsonMappingException;
import io.github.microcks.util.grpc.GrpcUtil;
import io.github.microcks.web.MockControllerCommons;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class GrpcServerCallHandler {
    private static Logger log = LoggerFactory.getLogger(GrpcServerCallHandler.class);
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${mocks.enable-invocation-stats}")
    private final Boolean enableInvocationStats = null;

    public ServerCallHandler<byte[], byte[]> getUnaryServerCallHandler(String fullMethodName) {
        return ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new MockedUnaryMethod(fullMethodName));
    }

    private String computeDispatchCriteria(String dispatcher, String dispatcherRules, String jsonBody) {
        String dispatchCriteria = null;
        if (dispatcher != null) {
            switch (dispatcher) {
                case "JSON_BODY": {
                    try {
                        JsonEvaluationSpecification specification = JsonEvaluationSpecification.buildFromJsonString(dispatcherRules);
                        dispatchCriteria = JsonExpressionEvaluator.evaluate(jsonBody, specification);
                        break;
                    }
                    catch (JsonMappingException jme) {
                        log.error("Dispatching rules of operation cannot be interpreted as JsonEvaluationSpecification", (Throwable)jme);
                    }
                }
            }
        }
        return dispatchCriteria;
    }

    protected class MockedUnaryMethod
    implements ServerCalls.UnaryMethod<byte[], byte[]> {
        private String fullMethodName;
        private String serviceName;
        private String serviceVersion;
        private String operationName;

        public MockedUnaryMethod(String fullMethodName) {
            this.fullMethodName = fullMethodName;
            this.operationName = fullMethodName.substring(fullMethodName.indexOf("/") + 1);
            this.serviceName = fullMethodName.substring(fullMethodName.lastIndexOf(".") + 1, fullMethodName.indexOf("/"));
            String packageName = fullMethodName.substring(0, fullMethodName.lastIndexOf("."));
            String[] parts = packageName.split("\\.");
            this.serviceVersion = parts.length > 2 ? parts[parts.length - 1] : packageName;
        }

        public void invoke(byte[] bytes, StreamObserver<byte[]> streamObserver) {
            log.info("Servicing mock response for service [{}, {}] and method {}", new Object[]{this.serviceName, this.serviceVersion, this.operationName});
            DynamicMessage outMsg = null;
            long startTime = System.currentTimeMillis();
            try {
                Service service = GrpcServerCallHandler.this.serviceRepository.findByNameAndVersion(this.serviceName, this.serviceVersion);
                if (service == null) {
                    log.debug("No GRPC Service def found for [{}, {}]", (Object)this.serviceName, (Object)this.serviceVersion);
                    streamObserver.onError((Throwable)Status.UNIMPLEMENTED.withDescription("No GRPC Service def found for " + this.fullMethodName).asException());
                    return;
                }
                Operation grpcOperation = null;
                for (Operation operation : service.getOperations()) {
                    if (!operation.getName().equals(this.operationName)) continue;
                    grpcOperation = operation;
                    break;
                }
                if (grpcOperation != null) {
                    List<Resource> resources;
                    log.debug("Found a valid operation {} with rules: {}", (Object)grpcOperation.getName(), (Object)grpcOperation.getDispatcherRules());
                    String dispatcher = grpcOperation.getDispatcher();
                    String dispatcherRules = grpcOperation.getDispatcherRules();
                    FallbackSpecification fallback = MockControllerCommons.getFallbackIfAny(grpcOperation);
                    if (fallback != null) {
                        dispatcher = fallback.getDispatcher();
                        dispatcherRules = fallback.getDispatcherRules();
                    }
                    if ((resources = GrpcServerCallHandler.this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.PROTOBUF_DESCRIPTOR)) == null || resources.size() != 1) {
                        log.error("Did not found any pre-processed Protobuf binary descriptor...");
                    }
                    Resource pbResource = resources.get(0);
                    Descriptors.MethodDescriptor md = GrpcUtil.findMethodDescriptor(pbResource.getContent(), this.serviceName, this.operationName);
                    DynamicMessage inMsg = DynamicMessage.parseFrom((Descriptors.Descriptor)md.getInputType(), (byte[])bytes);
                    String jsonBody = JsonFormat.printer().print((MessageOrBuilder)inMsg);
                    log.debug("Request body: {}", (Object)jsonBody);
                    String dispatchCriteria = GrpcServerCallHandler.this.computeDispatchCriteria(dispatcher, dispatcherRules, jsonBody);
                    log.debug("Dispatch criteria for finding response is {}", (Object)dispatchCriteria);
                    List<Response> responses = GrpcServerCallHandler.this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)grpcOperation), dispatchCriteria);
                    if (responses.isEmpty() && fallback != null) {
                        responses = GrpcServerCallHandler.this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)grpcOperation), fallback.getFallback());
                    }
                    if (responses.size() > 0) {
                        Response response = responses.get(0);
                        DynamicMessage.Builder outBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)md.getOutputType());
                        String responseContent = MockControllerCommons.renderResponseContent(jsonBody, response);
                        JsonFormat.parser().merge(responseContent, (Message.Builder)outBuilder);
                        outMsg = outBuilder.build();
                        if (grpcOperation.getDefaultDelay() != null) {
                            MockControllerCommons.waitForDelay(startTime, grpcOperation.getDefaultDelay());
                        }
                        if (GrpcServerCallHandler.this.enableInvocationStats.booleanValue()) {
                            MockControllerCommons.publishMockInvocation(GrpcServerCallHandler.this.applicationContext, this, service, response, startTime);
                        }
                        streamObserver.onNext((Object)outMsg.toByteArray());
                        streamObserver.onCompleted();
                    } else {
                        log.info("No appropriate response found for this input {}, returning an error", (Object)jsonBody);
                        streamObserver.onError((Throwable)Status.NOT_FOUND.withDescription("No response found for the GRPC input request").asException());
                    }
                } else {
                    log.debug("No valid operation found for [{}, {}] and {}", new Object[]{this.serviceName, this.serviceVersion, this.operationName});
                    streamObserver.onError((Throwable)Status.UNIMPLEMENTED.withDescription("No valid operation found for " + this.fullMethodName).asException());
                }
            }
            catch (Throwable t) {
                log.error("Unexpected throwable during GRPC input request processing", t);
                streamObserver.onError((Throwable)Status.UNKNOWN.withDescription("Unexpected throwable during GRPC input request processing").withCause(t).asException());
                t.printStackTrace();
            }
        }
    }
}

