/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;

public class MetadataExtractor {
    public static void completeMetadata(Metadata metadata, JsonNode node) {
        JsonNode labelsNode;
        JsonNode annotationsNode = node.get("annotations");
        if (annotationsNode != null) {
            annotationsNode.fields().forEachRemaining(entry -> metadata.setAnnotation((String)entry.getKey(), ((JsonNode)entry.getValue()).asText()));
        }
        if ((labelsNode = node.get("labels")) != null) {
            labelsNode.fields().forEachRemaining(entry -> metadata.setLabel((String)entry.getKey(), ((JsonNode)entry.getValue()).asText()));
        }
    }

    public static void completeOperationProperties(Operation operation, JsonNode node) {
        if (node.has("delay")) {
            operation.setDefaultDelay(Long.valueOf(node.path("delay").asLong(0L)));
        }
        if (node.has("frequency")) {
            operation.setDefaultDelay(Long.valueOf(node.path("frequency").asLong()));
        }
        if (node.has("dispatcher")) {
            operation.setDispatcher(node.path("dispatcher").asText());
        }
        if (node.has("dispatcherRules")) {
            operation.setDispatcherRules(node.path("dispatcherRules").asText());
        }
    }
}

