/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.Executor;

public class TokenCallCredentials
extends CallCredentials {
    public static final Metadata.Key<String> AUTHORIZATION_METADATA_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final String BEARER_TYPE = "Bearer";
    private String token;
    private String tokenHeader;

    public TokenCallCredentials(String token, String tokenHeader) {
        this.token = token;
        this.tokenHeader = tokenHeader;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
        executor.execute(() -> {
            try {
                Metadata headers = new Metadata();
                if (this.tokenHeader == null) {
                    headers.put(AUTHORIZATION_METADATA_KEY, (Object)(BEARER_TYPE + this.token));
                } else {
                    headers.put(Metadata.Key.of((String)this.tokenHeader, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.token);
                }
                metadataApplier.apply(headers);
            }
            catch (Throwable e) {
                metadataApplier.fail(Status.UNAUTHENTICATED.withCause(e));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

