/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.microcks.domain.GenericResource;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.repository.GenericResourceRepository;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.ResourceUtil;
import io.github.microcks.util.openapi.OpenAPISchemaBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ResourceController {
    private static Logger log = LoggerFactory.getLogger(ResourceController.class);
    private static final String SWAGGER_20 = "swagger_20";
    private static final String OPENAPI_30 = "openapi_30";
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private GenericResourceRepository genericResourceRepository;

    @RequestMapping(value={"/resources/{name}"}, method={RequestMethod.GET})
    public ResponseEntity<?> execute(@PathVariable(value="name") String name, HttpServletRequest request) {
        String extension = request.getRequestURI().substring(request.getRequestURI().lastIndexOf(46));
        try {
            name = URLDecoder.decode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error("Exception while decoding resource name: {}", (Object)e.getMessage());
        }
        log.info("Requesting resource named " + name);
        Resource resource = this.resourceRepository.findByName(name);
        if (resource != null) {
            HttpHeaders headers = new HttpHeaders();
            if (".json".equals(extension)) {
                headers.setContentType(MediaType.APPLICATION_JSON);
            } else if (".yaml".equals(extension) || ".yml".equals(extension)) {
                headers.set("Content-Type", "text/yaml");
                headers.setContentDisposition(ContentDisposition.builder((String)"inline").filename(name).build());
            } else if (".wsdl".equals(extension) || ".xsd".equals(extension)) {
                headers.setContentType(MediaType.TEXT_XML);
            } else if (".avsc".equals(extension)) {
                headers.setContentType(MediaType.APPLICATION_JSON);
            }
            return new ResponseEntity((Object)resource.getContent(), (MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/resources/service/{serviceId}"}, method={RequestMethod.GET})
    public List<Resource> getServiceResources(@PathVariable(value="serviceId") String serviceId) {
        log.debug("Request resources for service {}", (Object)serviceId);
        return this.resourceRepository.findByServiceId(serviceId);
    }

    @RequestMapping(value={"/resources/{serviceId}/{resourceType}"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getServiceResource(@PathVariable(value="serviceId") String serviceId, @PathVariable(value="resourceType") String resourceType, HttpServletResponse response) {
        log.info("Requesting {} resource for service {}", (Object)resourceType, (Object)serviceId);
        Service service = this.serviceRepository.findById(serviceId).orElse(null);
        if (service != null && ServiceType.GENERIC_REST.equals((Object)service.getType())) {
            JsonNode referenceSchema = null;
            List<GenericResource> genericResources = this.genericResourceRepository.findReferencesByServiceId(serviceId);
            if (genericResources != null && !genericResources.isEmpty()) {
                try {
                    Document reference = genericResources.get(0).getPayload();
                    reference.append("id", (Object)genericResources.get(0).getId());
                    referenceSchema = OpenAPISchemaBuilder.buildTypeSchemaFromJson((String)reference.toJson());
                }
                catch (Exception e) {
                    log.warn("Exception while building reference schema", (Throwable)e);
                }
            }
            InputStream stream = null;
            String resource = this.findResource(service);
            HttpHeaders headers = new HttpHeaders();
            String templatePath = null;
            if (SWAGGER_20.equals(resourceType)) {
                templatePath = "templates/swagger-2.0.yaml";
            } else if (OPENAPI_30.equals(resourceType)) {
                templatePath = "templates/openapi-3.0.yaml";
            }
            try {
                stream = ResourceUtil.getClasspathResource(templatePath);
            }
            catch (IOException e) {
                log.error("IOException while reading {} template: {}", (Object)templatePath, (Object)e.getMessage());
            }
            headers.set("Content-Type", "text/yaml");
            if (stream != null) {
                String result = ResourceUtil.replaceTemplatesInSpecStream(stream, service, resource, referenceSchema, null);
                return new ResponseEntity((Object)result.getBytes(), (MultiValueMap)headers, HttpStatus.OK);
            }
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    private String findResource(Service service) {
        for (Operation operation : service.getOperations()) {
            if (!operation.getName().startsWith("GET /") || operation.getName().endsWith("/:id")) continue;
            return operation.getName().substring("GET /".length());
        }
        return null;
    }
}

