/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.script;

import io.github.microcks.util.script.FakeScriptMockRequest;
import io.github.microcks.util.script.HttpHeadersStringToStringsMap;
import java.util.Collections;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineBinder {
    private static Logger log = LoggerFactory.getLogger(ScriptEngineBinder.class);

    public static void bindEnvironment(ScriptEngine engine, String requestContent, Map<String, Object> requestContext) {
        ScriptEngineBinder.bindEnvironment(engine, requestContent, requestContext, null);
    }

    public static void bindEnvironment(ScriptEngine engine, String requestContent, Map<String, Object> requestContext, HttpServletRequest request) {
        HttpHeadersStringToStringsMap headers = new HttpHeadersStringToStringsMap();
        if (request != null) {
            for (String headerName : Collections.list(request.getHeaderNames())) {
                headers.put(headerName, Collections.list(request.getHeaders(headerName)));
            }
        }
        FakeScriptMockRequest mockRequest = new FakeScriptMockRequest(requestContent, headers);
        mockRequest.setRequest(request);
        Bindings bindings = engine.createBindings();
        bindings.put("mockRequest", (Object)mockRequest);
        bindings.put("log", (Object)log);
        bindings.put("requestContext", (Object)requestContext);
        engine.setBindings(bindings, 100);
    }
}

