/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.SoapMessageValidator;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.script.ScriptEngineBinder;
import io.github.microcks.util.soapui.SoapUIXPathBuilder;
import io.github.microcks.web.DispatchContext;
import io.github.microcks.web.MockControllerCommons;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.HttpServletRequest;
import javax.xml.xpath.XPathExpression;
import org.apache.commons.lang3.RandomUtils;
import org.apache.xmlbeans.XmlError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriUtils;
import org.xml.sax.InputSource;

@RestController
@RequestMapping(value={"/soap"})
public class SoapController {
    private static Logger log = LoggerFactory.getLogger(SoapController.class);
    private static final Pattern OPERATION_CAPTURE_PATTERN = Pattern.compile("(.*):Body>(\\s*)<((\\w+):|)(?<operation>\\w+)(.*)(/)?>(.*)", 32);
    private static final Pattern SOAPUI_TEMPLATE_PARAMETER_REPLACE_PATTERN = Pattern.compile("\\$\\{ *([a-zA-Z0-9-_]+) *\\}", 32);
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${mocks.enable-invocation-stats}")
    private final Boolean enableInvocationStats = null;
    @Value(value="${validation.resourceUrl}")
    private final String resourceUrl;

    public SoapController() {
        this.resourceUrl = null;
    }

    @RequestMapping(value={"/{service}/{version}/**"}, method={RequestMethod.POST})
    public ResponseEntity<?> execute(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @RequestParam(value="validate", required=false) Boolean validate, @RequestParam(value="delay", required=false) Long delay, @RequestBody String body, HttpServletRequest request) {
        log.info("Servicing mock response for service [{}, {}]", (Object)serviceName, (Object)version);
        log.debug("Request body: " + body);
        long startTime = System.currentTimeMillis();
        if (serviceName.contains("+")) {
            serviceName = serviceName.replace('+', ' ');
        }
        log.info("Service name: " + serviceName);
        Service service = this.serviceRepository.findByNameAndVersion(serviceName, version);
        Object rOperation = null;
        String action = this.extractSoapAction(request);
        log.debug("Extracted SOAP action from headers: {}", (Object)action);
        if (action != null && action.length() > 0) {
            for (Object operation : service.getOperations()) {
                if (!action.equals(operation.getAction())) continue;
                rOperation = operation;
                log.info("Found valid operation {}", (Object)rOperation.getName());
                break;
            }
        }
        if (rOperation == null) {
            String operationName = this.extractOperationName(body);
            log.debug("Extracted operation name from payload: {}", (Object)operationName);
            if (operationName != null) {
                for (Operation operation : service.getOperations()) {
                    if (!operationName.equals(operation.getInputName()) && !operationName.equals(operation.getName())) continue;
                    rOperation = operation;
                    log.info("Found valid operation {}", (Object)rOperation.getName());
                    break;
                }
            }
        }
        if (rOperation != null) {
            log.debug("Found a valid operation with rules: {}", (Object)rOperation.getDispatcherRules());
            if (validate != null && validate.booleanValue()) {
                log.debug("Soap message validation is turned on, validating...");
                try {
                    List<XmlError> errors = SoapMessageValidator.validateSoapMessage(rOperation.getInputName(), service.getXmlNS(), body, this.resourceUrl + UriUtils.encodePath((String)(service.getName() + "-" + version), (String)"UTF-8") + ".wsdl", true);
                    log.debug("SoapBody validation errors: " + errors.size());
                    if (errors != null && errors.size() > 0) {
                        return new ResponseEntity(errors, HttpStatus.BAD_REQUEST);
                    }
                }
                catch (Exception e) {
                    log.error("Error during Soap validation", (Throwable)e);
                    return new ResponseEntity((Object)("Error during Soap validation: " + e.getMessage()), HttpStatus.BAD_REQUEST);
                }
            }
            String dispatcher = rOperation.getDispatcher();
            String dispatcherRules = rOperation.getDispatcherRules();
            FallbackSpecification fallback = MockControllerCommons.getFallbackIfAny(rOperation);
            if (fallback != null) {
                dispatcher = fallback.getDispatcher();
                dispatcherRules = fallback.getDispatcherRules();
            }
            Response response = null;
            DispatchContext dispatchContext = null;
            if ("QUERY_MATCH".equals(dispatcher)) {
                dispatchContext = this.getDispatchCriteriaFromXPathEval(dispatcherRules, body);
            } else if ("SCRIPT".equals(dispatcher)) {
                dispatchContext = this.getDispatchCriteriaFromScriptEval(dispatcherRules, body, request);
            } else if ("RANDOM".equals(dispatcher)) {
                dispatchContext = new DispatchContext("RANDOM", null);
            }
            log.debug("Dispatch criteria for finding response is {}", (Object)dispatchContext.dispatchCriteria());
            List<Response> responses = this.responseRepository.findByOperationIdAndDispatchCriteria(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), dispatchContext.dispatchCriteria());
            if (responses.isEmpty() && fallback != null) {
                responses = this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)rOperation), fallback.getFallback());
            }
            if (!responses.isEmpty()) {
                int idx = "RANDOM".equals(dispatcher) ? RandomUtils.nextInt((int)0, (int)responses.size()) : 0;
                response = responses.get(idx);
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            if (request.getContentType().startsWith("application/soap+xml")) {
                responseHeaders.setContentType(MediaType.valueOf((String)"application/soap+xml;charset=UTF-8"));
            } else {
                responseHeaders.setContentType(MediaType.valueOf((String)"text/xml;charset=UTF-8"));
            }
            response.setContent(SoapController.convertSoapUITemplate(response.getContent()));
            String responseContent = MockControllerCommons.renderResponseContent(body, null, request, dispatchContext.requestContext(), response);
            if (delay == null && rOperation.getDefaultDelay() != null) {
                delay = rOperation.getDefaultDelay();
            }
            MockControllerCommons.waitForDelay(startTime, delay);
            if (this.enableInvocationStats.booleanValue()) {
                MockControllerCommons.publishMockInvocation(this.applicationContext, this, service, response, startTime);
            }
            if (response.isFault()) {
                return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((Object)responseContent, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        log.debug("No valid operation found by Microcks...");
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    protected boolean hasPayloadCorrectStructureForOperation(String payload, String operationName) {
        String openingPattern = "(.*):Body>(\\s*)<((\\w+):|)" + operationName + "(.*)>(.*)";
        String closingPattern = "(.*)</((\\w+):|)" + operationName + ">(\\s*)</(.*):Body>(.*)";
        String shortPattern = "(.*):Body>(\\s*)<((\\w+):|)" + operationName + "(.*)/>(\\s*)</(.*):Body>(.*)";
        Pattern op = Pattern.compile(openingPattern, 32);
        Pattern cp = Pattern.compile(closingPattern, 32);
        Pattern sp = Pattern.compile(shortPattern, 32);
        return op.matcher(payload).matches() && cp.matcher(payload).matches() || sp.matcher(payload).matches();
    }

    protected String extractOperationName(String payload) {
        Matcher matcher = OPERATION_CAPTURE_PATTERN.matcher(payload);
        if (matcher.find()) {
            return matcher.group("operation");
        }
        return null;
    }

    protected String extractSoapAction(HttpServletRequest request) {
        String action = null;
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("application/soap+xml") && contentType.contains("action=")) {
            action = contentType.substring(contentType.indexOf("action=") + 7);
            if (action.contains(";")) {
                action = action.substring(0, action.indexOf(";"));
            }
        } else {
            action = request.getHeader("SOAPAction");
        }
        if (action != null) {
            if (action.startsWith("\"")) {
                action = action.substring(1);
            }
            if (action.endsWith("\"")) {
                action = action.substring(0, action.length() - 1);
            }
        }
        return action;
    }

    private DispatchContext getDispatchCriteriaFromXPathEval(String dispatcherRules, String body) {
        try {
            XPathExpression xpath = SoapUIXPathBuilder.buildXPathMatcherFromRules(dispatcherRules);
            return new DispatchContext(xpath.evaluate(new InputSource(new StringReader(body))), null);
        }
        catch (Exception e) {
            log.error("Error during Xpath evaluation", (Throwable)e);
            return null;
        }
    }

    private DispatchContext getDispatchCriteriaFromScriptEval(String dispatcherRules, String body, HttpServletRequest request) {
        ScriptEngineManager sem = new ScriptEngineManager();
        HashMap<String, Object> requestContext = new HashMap<String, Object>();
        try {
            ScriptEngine se = sem.getEngineByExtension("groovy");
            ScriptEngineBinder.bindEnvironment(se, body, requestContext, request);
            return new DispatchContext((String)se.eval(dispatcherRules), requestContext);
        }
        catch (Exception e) {
            log.error("Error during Script evaluation", (Throwable)e);
            return null;
        }
    }

    protected static String convertSoapUITemplate(String responseTemplate) {
        if (responseTemplate.contains("${")) {
            return SOAPUI_TEMPLATE_PARAMETER_REPLACE_PATTERN.matcher(responseTemplate).replaceAll("{{ $1 }}");
        }
        return responseTemplate;
    }
}

