/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.config;

import io.github.microcks.config.ProxySettings;
import io.github.microcks.util.UsernamePasswordProxyAuthenticator;
import java.net.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class ProxyConfiguration {
    private static Logger log = LoggerFactory.getLogger(ProxyConfiguration.class);
    @Value(value="${network.proxyHost}")
    private String proxyHost;
    @Value(value="${network.nonProxyHosts}")
    private String nonProxyHosts;
    @Value(value="${network.proxyPort}")
    private Integer proxyPort;
    @Value(value="${network.proxyUsername}")
    private String proxyUsername;
    @Value(value="${network.proxyPassword}")
    private String proxyPassword;

    @Bean
    public ProxySettings buildProxySettings() {
        if (this.proxyHost != null && this.proxyPort != null) {
            log.info("Configuring HTTP(S) proxy to {}:{}", (Object)this.proxyHost, (Object)this.proxyPort);
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", this.proxyPort.toString());
            System.setProperty("http.nonProxyHosts", this.nonProxyHosts);
            System.setProperty("https.proxyHost", this.proxyHost);
            System.setProperty("https.proxyPort", this.proxyPort.toString());
            System.setProperty("https.nonProxyHosts", this.nonProxyHosts);
            if (this.proxyUsername != null && this.proxyPassword != null) {
                System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
            }
            ProxySettings settings = new ProxySettings(this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword);
            Authenticator.setDefault(new UsernamePasswordProxyAuthenticator(settings));
            return settings;
        }
        return null;
    }
}

