/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.repository;

import io.github.microcks.domain.Service;
import io.github.microcks.repository.CustomServiceRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.ObjectOperators;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class ServiceRepositoryImpl
implements CustomServiceRepository {
    @Autowired
    private MongoTemplate template;

    @Override
    public List<Service> findByIdIn(List<String> ids) {
        ArrayList<ObjectId> objIds = new ArrayList<ObjectId>();
        for (String id : ids) {
            objIds.add(new ObjectId(id));
        }
        List results = this.template.find(new Query((CriteriaDefinition)Criteria.where((String)"_id").in(objIds)), Service.class);
        return results;
    }

    @Override
    public List<Service> findByLabels(Map<String, String> labels) {
        Query query = new Query();
        for (String labelKey : labels.keySet()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)("metadata.labels." + labelKey)).is((Object)labels.get(labelKey)));
        }
        List results = this.template.find(query, Service.class);
        return results;
    }

    @Override
    public List<Service> findByLabelsAndNameLike(Map<String, String> labels, String name) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"name").regex(name, "i"));
        for (String labelKey : labels.keySet()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)("metadata.labels." + labelKey)).is((Object)labels.get(labelKey)));
        }
        List results = this.template.find(query, Service.class);
        return results;
    }

    @Override
    public List<CustomServiceRepository.ServiceCount> countServicesByType() {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.project((String[])new String[]{"type"}), Aggregation.group((String[])new String[]{"type"}).count().as("number"), Aggregation.project((String[])new String[]{"number"}).and("type").previousOperation(), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"number"})});
        AggregationResults results = this.template.aggregate(aggregation, Service.class, CustomServiceRepository.ServiceCount.class);
        return results.getMappedResults();
    }

    @Override
    public List<CustomServiceRepository.LabelValues> listLabels() {
        ObjectOperators.ObjectToArray labels = ObjectOperators.ObjectToArray.valueOfToArray((String)"metadata.labels");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.project((String[])new String[0]).and((AggregationExpression)labels).as("labels"), Aggregation.unwind((String)"labels"), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"labels.v"}), Aggregation.group((String[])new String[]{"labels.k"}).addToSet("labels.v").as("values").first("labels.k").as("key")});
        AggregationResults results = this.template.aggregate(aggregation, Service.class, CustomServiceRepository.LabelValues.class);
        return results.getMappedResults();
    }
}

