/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.security;

import io.github.microcks.domain.OAuth2AuthorizedClient;
import io.github.microcks.domain.OAuth2ClientContext;
import io.github.microcks.domain.OAuth2GrantType;
import io.github.microcks.security.AuthorizationException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.endpoint.DefaultClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultPasswordTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2PasswordGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;

public class OAuth2AuthorizedClientProvider {
    private static Logger log = LoggerFactory.getLogger(OAuth2AuthorizedClientProvider.class);

    public OAuth2AuthorizedClient authorize(OAuth2ClientContext oAuth2ClientContext) throws AuthorizationException {
        OAuth2AccessToken accessToken = null;
        try {
            switch (oAuth2ClientContext.getGrantType()) {
                case PASSWORD: {
                    accessToken = this.getResourceOwnerPasswordAccessToken(oAuth2ClientContext);
                    break;
                }
                case CLIENT_CREDENTIALS: {
                    accessToken = this.getClientCredentialsAccessToken(oAuth2ClientContext);
                    break;
                }
                case REFRESH_TOKEN: {
                    accessToken = this.getRefreshTokenAccessToken(oAuth2ClientContext);
                }
            }
        }
        catch (OAuth2AuthorizationException oAuth2AuthorizationException) {
            log.error("Error during {} grant type fetching", (Object)oAuth2ClientContext.getGrantType(), (Object)oAuth2AuthorizationException);
            throw new AuthorizationException("Error during " + oAuth2ClientContext.getGrantType() + " grant type fetching", oAuth2AuthorizationException);
        }
        String principalName = oAuth2ClientContext.getClientId();
        if (oAuth2ClientContext.getGrantType() == OAuth2GrantType.PASSWORD) {
            principalName = oAuth2ClientContext.getUsername();
        }
        return new OAuth2AuthorizedClient(oAuth2ClientContext.getGrantType(), principalName, oAuth2ClientContext.getTokenUri(), accessToken.getTokenValue());
    }

    private OAuth2AccessToken getResourceOwnerPasswordAccessToken(OAuth2ClientContext oAuth2ClientContext) {
        ClientRegistration registration = this.initializeClientRegistration(oAuth2ClientContext).authorizationGrantType(AuthorizationGrantType.PASSWORD).build();
        DefaultPasswordTokenResponseClient client = new DefaultPasswordTokenResponseClient();
        OAuth2PasswordGrantRequest request = new OAuth2PasswordGrantRequest(registration, oAuth2ClientContext.getUsername(), oAuth2ClientContext.getPassword());
        OAuth2AccessTokenResponse response = client.getTokenResponse(request);
        return response.getAccessToken();
    }

    private OAuth2AccessToken getClientCredentialsAccessToken(OAuth2ClientContext oAuth2ClientContext) {
        ClientRegistration registration = this.initializeClientRegistration(oAuth2ClientContext).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
        DefaultClientCredentialsTokenResponseClient client = new DefaultClientCredentialsTokenResponseClient();
        OAuth2ClientCredentialsGrantRequest request = new OAuth2ClientCredentialsGrantRequest(registration);
        OAuth2AccessTokenResponse response = client.getTokenResponse(request);
        return response.getAccessToken();
    }

    private OAuth2AccessToken getRefreshTokenAccessToken(OAuth2ClientContext oAuth2ClientContext) {
        ClientRegistration registration = this.initializeClientRegistration(oAuth2ClientContext).authorizationGrantType(AuthorizationGrantType.REFRESH_TOKEN).build();
        DefaultRefreshTokenTokenResponseClient clientRT = new DefaultRefreshTokenTokenResponseClient();
        OAuth2RefreshTokenGrantRequest requestRT = new OAuth2RefreshTokenGrantRequest(registration, new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "fake-one", null, null), new OAuth2RefreshToken(oAuth2ClientContext.getRefreshToken(), null));
        OAuth2AccessTokenResponse response = clientRT.getTokenResponse(requestRT);
        return response.getAccessToken();
    }

    private ClientRegistration.Builder initializeClientRegistration(OAuth2ClientContext oAuth2ClientContext) {
        ClientRegistration.Builder builder = ClientRegistration.withRegistrationId((String)"microcks-test-idp").clientId(oAuth2ClientContext.getClientId()).clientSecret(oAuth2ClientContext.getClientSecret()).tokenUri(oAuth2ClientContext.getTokenUri());
        if (oAuth2ClientContext.getScopes() != null) {
            String[] scopes = (oAuth2ClientContext.getScopes() + " openid").split(" ");
            builder.scope(Arrays.asList(scopes));
        } else {
            builder.scope(new String[]{"openid"});
        }
        return builder;
    }
}

