/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLAAssertion
implements SoapUIAssertion {
    private static Logger log = LoggerFactory.getLogger(SLAAssertion.class);
    public static final String SLA_PARAM = "SLA";
    private long sla = 200L;
    private String errorMessage;

    @Override
    public void configure(Map<String, String> configParams) {
        if (configParams.containsKey(SLA_PARAM)) {
            try {
                this.sla = Long.valueOf(configParams.get(SLA_PARAM));
            }
            catch (NumberFormatException nfe) {
                log.warn("SLA config parameters cannot be cast to long, using 200ms as a default");
            }
        }
    }

    @Override
    public AssertionStatus assertResponse(RequestResponseExchange exchange, ExchangeContext context) {
        log.debug("Asserting response SLA of {}, actual duration: {}", (Object)this.sla, (Object)exchange.duration());
        if (exchange.duration() > this.sla) {
            this.errorMessage = "Response did not meet SLA " + exchange.duration() + "/" + this.sla;
            return AssertionStatus.FAILED;
        }
        return AssertionStatus.VALID;
    }

    @Override
    public List<String> getErrorMessages() {
        return List.of(this.errorMessage);
    }
}

