/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import io.micrometer.common.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleContainsAssertion
implements SoapUIAssertion {
    private static Logger log = LoggerFactory.getLogger(SimpleContainsAssertion.class);
    public static final String TOKEN_PARAM = "token";
    public static final String IGNORE_CASE_PARAM = "ignoreCase";
    public static final String USE_REGEX_PARAM = "useRegEx";
    protected String token;
    protected boolean ignoreCase = false;
    protected boolean useRegEx = false;
    protected String errorMessage;

    @Override
    public void configure(Map<String, String> configParams) {
        this.token = configParams.get(TOKEN_PARAM);
        if (configParams.containsKey(IGNORE_CASE_PARAM)) {
            this.ignoreCase = Boolean.valueOf(configParams.get(IGNORE_CASE_PARAM));
        }
        if (configParams.containsKey(USE_REGEX_PARAM)) {
            this.useRegEx = Boolean.valueOf(configParams.get(USE_REGEX_PARAM));
        }
    }

    @Override
    public AssertionStatus assertResponse(RequestResponseExchange exchange, ExchangeContext context) {
        log.debug("Asserting Simple contains for {}", (Object)this.token);
        if (this.token == null) {
            this.token = "";
        }
        String content = this.normalize(exchange.responseContent());
        int indexOfToken = -1;
        if (this.useRegEx) {
            Object tokenToUse = this.ignoreCase ? "(?i)" + this.token : this.token;
            Pattern p = Pattern.compile((String)tokenToUse, 32);
            Matcher m = p.matcher(content);
            if (m.find()) {
                indexOfToken = 0;
            }
        } else {
            int n = indexOfToken = this.ignoreCase ? content.toUpperCase().indexOf(this.token.toUpperCase()) : content.indexOf(this.token);
        }
        if (indexOfToken == -1) {
            this.errorMessage = "Missing token [" + this.token + "] in Response";
            return AssertionStatus.FAILED;
        }
        return AssertionStatus.VALID;
    }

    @Override
    public List<String> getErrorMessages() {
        return List.of(this.errorMessage);
    }

    private String normalize(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.replace("\r\n", "\n");
        }
        return string;
    }
}

