/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WildcardMatchingAssertion
implements SoapUIAssertion {
    private static Logger log = LoggerFactory.getLogger(WildcardMatchingAssertion.class);
    public static final String ALLOW_WILDCARDS = "allowWildcards";
    protected boolean allowWildcards = false;

    @Override
    public void configure(Map<String, String> configParams) {
        if (configParams.containsKey(ALLOW_WILDCARDS)) {
            this.allowWildcards = Boolean.valueOf(configParams.get(ALLOW_WILDCARDS));
        }
    }

    protected boolean isSimilar(String expectedContent, String realContent) {
        StringBuilder patternBuilder = new StringBuilder();
        if (expectedContent.startsWith("*")) {
            patternBuilder.append(".*");
        }
        String[] tokens = expectedContent.split(Pattern.quote("*"));
        boolean first = true;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.isEmpty()) continue;
            if (!first) {
                patternBuilder.append(".*");
            }
            first = false;
            patternBuilder.append(Pattern.quote(token));
        }
        if (expectedContent.endsWith("*")) {
            patternBuilder.append(".*");
        }
        log.debug("Compiled a pattern for wildcard match, will use '{}'", (Object)patternBuilder);
        return Pattern.compile(patternBuilder.toString()).matcher(realContent).matches();
    }
}

