/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.test;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.util.soap.SoapMessageValidator;
import io.github.microcks.util.test.HttpTestRunner;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;

public class SoapHttpTestRunner
extends HttpTestRunner {
    private static Logger log = LoggerFactory.getLogger(SoapHttpTestRunner.class);
    private String resourceUrl = null;
    private ResourceRepository resourceRepository;

    public SoapHttpTestRunner(ResourceRepository resourceRepository) {
        this.resourceRepository = resourceRepository;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return HttpMethod.POST;
    }

    @Override
    protected int extractTestReturnCode(Service service, Operation operation, Request request, ClientHttpResponse httpResponse, String responseContent) {
        int code = 0;
        code = super.extractTestReturnCode(service, operation, request, httpResponse, responseContent);
        if (1 == code) {
            return code;
        }
        Resource wsdlResource = this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.WSDL).get(0);
        List errors = SoapMessageValidator.validateSoapMessage((String)wsdlResource.getContent(), (QName)new QName(service.getXmlNS(), operation.getOutputName()), (String)responseContent, (String)this.resourceUrl);
        log.debug("SoapBody validation errors: " + errors.size());
        if (!errors.isEmpty()) {
            log.debug("Soap validation errors found " + errors.size() + ", marking test as failed.");
            return 1;
        }
        return code;
    }
}

