/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.GenericResource;
import io.github.microcks.repository.GenericResourceRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class GenericResourceController {
    private static Logger log = LoggerFactory.getLogger(GenericResourceController.class);
    public static final String ID_FIELD = "id";
    @Autowired
    GenericResourceRepository genericResourceRepository;

    @RequestMapping(value={"/genericresources/service/{serviceId}"}, method={RequestMethod.GET})
    public List<GenericResource> listResources(@PathVariable(value="serviceId") String serviceId, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="10") int size) {
        log.debug("List resources for service '{}'", (Object)serviceId);
        List<GenericResource> genericResources = this.genericResourceRepository.findByServiceId(serviceId, (Pageable)PageRequest.of((int)page, (int)size));
        List<GenericResource> resources = genericResources.stream().map(genericResource -> this.addIdToPayload((GenericResource)genericResource)).collect(Collectors.toList());
        return resources;
    }

    @RequestMapping(value={"/genericresources/service/{serviceId}/count"}, method={RequestMethod.GET})
    public Map<String, Long> countResources(@PathVariable(value="serviceId") String serviceId) {
        log.debug("Counting resources for service '{}'", (Object)serviceId);
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.genericResourceRepository.countByServiceId(serviceId));
        return counter;
    }

    private GenericResource addIdToPayload(GenericResource genericResource) {
        Document document = genericResource.getPayload();
        document.append(ID_FIELD, (Object)genericResource.getId());
        return genericResource;
    }
}

