/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Service;
import io.github.microcks.service.ArtifactInfo;
import io.github.microcks.service.ServiceService;
import io.github.microcks.util.HTTPDownloader;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.ReferenceResolver;
import io.github.microcks.util.RelativeReferenceURLBuilderFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class UploadArtifactController {
    private static Logger log = LoggerFactory.getLogger(UploadArtifactController.class);
    @Autowired
    private ServiceService serviceService;

    @PostMapping(value={"/artifact/download"})
    public ResponseEntity<?> importArtifact(@RequestParam(value="url", required=true) String url, @RequestParam(value="mainArtifact", defaultValue="true") boolean mainArtifact) {
        if (!url.isEmpty()) {
            List<Service> services = null;
            try {
                HTTPDownloader.FileAndHeaders fileAndHeaders = HTTPDownloader.handleHTTPDownloadToFileAndHeaders(url, null, true);
                File localFile = fileAndHeaders.getLocalFile();
                services = this.serviceService.importServiceDefinition(localFile, new ReferenceResolver(url, null, true, RelativeReferenceURLBuilderFactory.getRelativeReferenceURLBuilder(fileAndHeaders.getResponseHeaders())), new ArtifactInfo(url, mainArtifact));
            }
            catch (IOException ioe) {
                log.error("Exception while retrieving remote item " + url, (Throwable)ioe);
                return new ResponseEntity((Object)"Exception while retrieving remote item", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (MockRepositoryImportException mrie) {
                return new ResponseEntity((Object)mrie.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            if (services != null && !services.isEmpty()) {
                return new ResponseEntity((Object)("{\"name\": \"" + services.get(0).getName() + ":" + services.get(0).getVersion() + "\"}"), (HttpStatusCode)HttpStatus.CREATED);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/artifact/upload"})
    public ResponseEntity<?> importArtifact(@RequestParam(value="file") MultipartFile file, @RequestParam(value="mainArtifact", defaultValue="true") boolean mainArtifact) {
        if (!file.isEmpty()) {
            log.debug("Content type of {} is {}", (Object)file.getOriginalFilename(), (Object)file.getContentType());
            List<Service> services = null;
            try {
                String localFile = System.getProperty("java.io.tmpdir") + "/microcks-" + System.currentTimeMillis() + ".artifact";
                ReadableByteChannel rbc = null;
                FileOutputStream fos = null;
                try {
                    rbc = Channels.newChannel(file.getInputStream());
                    fos = new FileOutputStream(localFile);
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                    if (rbc != null) {
                        rbc.close();
                    }
                }
                services = this.serviceService.importServiceDefinition(new File(localFile), null, new ArtifactInfo(file.getOriginalFilename(), mainArtifact));
            }
            catch (IOException ioe) {
                log.error("Exception while writing uploaded item {}", (Object)file.getOriginalFilename(), (Object)ioe);
                return new ResponseEntity((Object)"Exception while writing uploaded item", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (MockRepositoryImportException mrie) {
                return new ResponseEntity((Object)mrie.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            if (services != null && !services.isEmpty()) {
                return new ResponseEntity((Object)(services.get(0).getName() + ":" + services.get(0).getVersion()), (HttpStatusCode)HttpStatus.CREATED);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

