/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.domain.Secret;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPDownloader {
    private static Logger log = LoggerFactory.getLogger(HTTPDownloader.class);
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";

    public static String getURLEtag(String remoteUrl, Secret secret, boolean disableSSLValidation) throws IOException {
        HttpURLConnection connection = HTTPDownloader.prepareURLConnection(remoteUrl, secret, disableSSLValidation);
        try {
            String etag = connection.getHeaderField("Etag");
            if (etag != null) {
                log.debug("Found an Etag for {} : {}", (Object)remoteUrl, (Object)etag);
                return etag;
            }
            etag = connection.getHeaderField("ETag");
            if (etag != null) {
                log.debug("Found an Etag for {} : {}", (Object)remoteUrl, (Object)etag);
                return etag;
            }
        }
        catch (Exception e) {
            log.error("Caught an exception while retrieving Etag for {}", (Object)remoteUrl, (Object)e);
        }
        log.debug("No Etag found for {} !", (Object)remoteUrl);
        return null;
    }

    public static File handleHTTPDownloadToFile(String remoteUrl, Secret secret, boolean disableSSLValidation) throws IOException {
        HttpURLConnection connection = HTTPDownloader.prepareURLConnection(remoteUrl, secret, disableSSLValidation);
        File localFile = File.createTempFile("microcks-" + System.currentTimeMillis(), ".download");
        try (ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
             FileOutputStream fos = new FileOutputStream(localFile);){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        return localFile;
    }

    public static FileAndHeaders handleHTTPDownloadToFileAndHeaders(String remoteUrl, Secret secret, boolean disableSSLValidation) throws IOException {
        HttpURLConnection connection = HTTPDownloader.prepareURLConnection(remoteUrl, secret, disableSSLValidation);
        File localFile = File.createTempFile("microcks-" + System.currentTimeMillis(), ".download");
        Map<String, List<String>> responseHeaders = null;
        try (ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
             FileOutputStream fos = new FileOutputStream(localFile);){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            responseHeaders = connection.getHeaderFields();
        }
        return new FileAndHeaders(localFile, responseHeaders);
    }

    private static HttpURLConnection prepareURLConnection(String remoteUrl, Secret secret, boolean disableSSLValidation) throws IOException {
        URL website = new URL(remoteUrl);
        HttpURLConnection connection = (HttpURLConnection)website.openConnection();
        if ("https".equals(website.getProtocol())) {
            try {
                if (disableSSLValidation) {
                    log.debug("SSL Validation is disabled for {}, installing accept everything TrustManager", (Object)remoteUrl);
                    HTTPDownloader.installAcceptEverythingTrustManager(connection);
                } else if (secret != null && secret.getCaCertPem() != null) {
                    log.debug("Secret for {} contains a CA Cert, installing certificate into TrustManager", (Object)remoteUrl);
                    HTTPDownloader.installCustomCaCertTrustManager(secret.getCaCertPem(), connection);
                }
            }
            catch (Exception e) {
                log.error("Caught exception while preparing TrustManager for connecting {}: {}", (Object)remoteUrl, (Object)e.getMessage());
                throw new IOException("SSL Connection with " + remoteUrl + " failed during preparation", e);
            }
        }
        if (secret != null) {
            if (secret.getUsername() != null && secret.getPassword() != null) {
                log.debug("Secret for {} contains username/password, assuming Authorization Basic", (Object)remoteUrl);
                String encoded = Base64.getEncoder().encodeToString((secret.getUsername() + ":" + secret.getPassword()).getBytes(StandardCharsets.UTF_8));
                connection.setRequestProperty("Authorization", "Basic " + encoded);
            }
            if (secret.getToken() != null) {
                if (secret.getTokenHeader() != null && secret.getTokenHeader().trim().length() > 0) {
                    log.debug("Secret for {} contains token and token header, adding them as request header", (Object)remoteUrl);
                    connection.setRequestProperty(secret.getTokenHeader().trim(), secret.getToken());
                } else {
                    log.debug("Secret for {} contains token only, assuming Authorization Bearer", (Object)remoteUrl);
                    connection.setRequestProperty("Authorization", "Bearer " + secret.getToken());
                }
            }
        }
        return connection;
    }

    private static void installAcceptEverythingTrustManager() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    private static void installAcceptEverythingTrustManager(HttpURLConnection connection) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        ((HttpsURLConnection)connection).setHostnameVerifier(allHostsValid);
    }

    private static void installCustomCaCertTrustManager(String caCertPem) throws Exception {
        String strippedPem = caCertPem.replaceAll(BEGIN_CERTIFICATE, "").replaceAll(END_CERTIFICATE, "");
        ByteArrayInputStream is = new ByteArrayInputStream(org.apache.commons.codec.binary.Base64.decodeBase64((String)strippedPem));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate caCert = (X509Certificate)cf.generateCertificate(is);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        ks.setCertificateEntry("caCert", caCert);
        tmf.init(ks);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmf.getTrustManagers(), null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
    }

    private static void installCustomCaCertTrustManager(String caCertPem, HttpURLConnection connection) throws Exception {
        String strippedPem = caCertPem.replaceAll(BEGIN_CERTIFICATE, "").replaceAll(END_CERTIFICATE, "");
        ByteArrayInputStream is = new ByteArrayInputStream(org.apache.commons.codec.binary.Base64.decodeBase64((String)strippedPem));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate caCert = (X509Certificate)cf.generateCertificate(is);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        ks.setCertificateEntry("caCert", caCert);
        tmf.init(ks);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmf.getTrustManagers(), null);
        ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
    }

    public static class FileAndHeaders {
        private File localFile;
        private Map<String, List<String>> responseHeaders;

        public FileAndHeaders(File localFile, Map<String, List<String>> responseHeaders) {
            this.localFile = localFile;
            this.responseHeaders = responseHeaders;
        }

        public File getLocalFile() {
            return this.localFile;
        }

        public Map<String, List<String>> getResponseHeaders() {
            return this.responseHeaders;
        }
    }
}

