/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.springframework.util.unit.DataSize;
import org.yaml.snakeyaml.LoaderOptions;

public class ObjectMapperFactory {
    private static int codePointLimit = 0x300000;

    private ObjectMapperFactory() {
    }

    public static void configureMaxFileSize(String maxFileSize) {
        int codePointLimitCandidate = (int)DataSize.parse((CharSequence)maxFileSize).toBytes();
        if (codePointLimitCandidate > codePointLimit) {
            codePointLimit = codePointLimitCandidate;
        }
    }

    public static ObjectMapper getJsonObjectMapper() {
        return new ObjectMapper();
    }

    public static ObjectMapper getYamlObjectMapper() {
        LoaderOptions options = new LoaderOptions();
        options.setCodePointLimit(codePointLimit);
        YAMLFactory yamlFactory = YAMLFactory.builder().loaderOptions(options).build();
        return new ObjectMapper((JsonFactory)yamlFactory);
    }
}

