/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.postman;

import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostmanUtil {
    private static Logger log = LoggerFactory.getLogger(PostmanUtil.class);
    private static final String OPERATION_NAME_EXPRESSION_PREFIX = "(GET|POST|PUT|PATCH|DELETE|OPTION)?( *)(/)?";

    private PostmanUtil() {
    }

    public static boolean areOperationsEquivalent(String operationNameRef, String operationNameCandidate) {
        String transformedName;
        if (operationNameRef.equalsIgnoreCase(operationNameCandidate)) {
            return true;
        }
        if (operationNameRef.contains("/{") && (transformedName = operationNameRef.replaceAll("/\\{", "/:").replace("}", "")).equalsIgnoreCase(operationNameCandidate)) {
            return true;
        }
        try {
            return operationNameCandidate.matches(OPERATION_NAME_EXPRESSION_PREFIX + operationNameRef);
        }
        catch (PatternSyntaxException pse) {
            log.warn("{}{} throws a PatternSyntaxException", (Object)OPERATION_NAME_EXPRESSION_PREFIX, (Object)operationNameRef);
            return false;
        }
    }
}

