/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.event.MockInvocationEvent;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.dispatcher.JsonMappingException;
import io.github.microcks.util.el.EvaluableRequest;
import io.github.microcks.util.el.TemplateEngine;
import io.github.microcks.util.el.TemplateEngineFactory;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class MockControllerCommons {
    private static final Logger log = LoggerFactory.getLogger(MockControllerCommons.class);
    private static final String RENDERING_MESSAGE = "Response contains dynamic EL expression, rendering it...";

    private MockControllerCommons() {
    }

    public static FallbackSpecification getFallbackIfAny(Operation rOperation) {
        FallbackSpecification fallback = null;
        if ("FALLBACK".equals(rOperation.getDispatcher())) {
            try {
                fallback = FallbackSpecification.buildFromJsonString(rOperation.getDispatcherRules());
            }
            catch (JsonMappingException jme) {
                log.error("Dispatching rules of operation cannot be interpreted as FallbackSpecification", (Throwable)jme);
            }
        }
        return fallback;
    }

    public static String renderResponseContent(String requestBody, Map<String, Object> requestContext, Response response) {
        if (response.getContent() != null && response.getContent().contains("{{")) {
            log.debug(RENDERING_MESSAGE);
            EvaluableRequest evaluableRequest = new EvaluableRequest(requestBody, null);
            return MockControllerCommons.unguardedRenderResponseContent(evaluableRequest, requestContext, TemplateEngineFactory.getTemplateEngine(), response.getContent());
        }
        return response.getContent();
    }

    public static String renderResponseContent(String requestBody, Map<String, String> evaluableParams, Map<String, String> evaluableHeaders, Map<String, Object> requestContext, Response response) {
        if (response.getContent() != null && response.getContent().contains("{{")) {
            log.debug(RENDERING_MESSAGE);
            EvaluableRequest evaluableRequest = new EvaluableRequest(requestBody, null);
            evaluableRequest.setParams(evaluableParams);
            evaluableRequest.setHeaders(evaluableHeaders);
            return MockControllerCommons.unguardedRenderResponseContent(evaluableRequest, requestContext, TemplateEngineFactory.getTemplateEngine(), response.getContent());
        }
        return response.getContent();
    }

    public static String renderResponseContent(String requestBody, String requestResourcePath, HttpServletRequest request, Map<String, Object> requestContext, Response response) {
        if (response.getContent() != null && response.getContent().contains("{{")) {
            log.debug(RENDERING_MESSAGE);
            EvaluableRequest evaluableRequest = MockControllerCommons.buildEvaluableRequest(requestBody, requestResourcePath, request);
            return MockControllerCommons.unguardedRenderResponseContent(evaluableRequest, requestContext, TemplateEngineFactory.getTemplateEngine(), response.getContent());
        }
        return response.getContent();
    }

    public static String renderResponseContent(EvaluableRequest evaluableRequest, TemplateEngine engine, String responseContent) {
        if (responseContent != null && responseContent.contains("{{")) {
            return MockControllerCommons.unguardedRenderResponseContent(evaluableRequest, null, engine, responseContent);
        }
        return responseContent;
    }

    private static String unguardedRenderResponseContent(EvaluableRequest evaluableRequest, Map<String, Object> requestContext, TemplateEngine engine, String responseContent) {
        engine.getContext().setVariable("request", (Object)evaluableRequest);
        if (requestContext != null) {
            engine.getContext().setVariables(requestContext);
        }
        try {
            return engine.getValue(responseContent);
        }
        catch (Throwable t) {
            log.error("Failing at evaluating template {}", (Object)responseContent, (Object)t);
            return responseContent;
        }
    }

    public static EvaluableRequest buildEvaluableRequest(String requestBody, String requestResourcePath, HttpServletRequest request) {
        EvaluableRequest evaluableRequest = new EvaluableRequest(requestBody, requestResourcePath != null ? requestResourcePath.split("/") : null);
        HashMap<String, String> evaluableParams = new HashMap<String, String>();
        ArrayList<String> parameterNames = Collections.list(request.getParameterNames());
        for (String parameter : parameterNames) {
            evaluableParams.put(parameter, request.getParameter(parameter));
        }
        evaluableRequest.setParams(evaluableParams);
        HashMap<String, String> evaluableHeaders = new HashMap<String, String>();
        ArrayList<String> headerNames = Collections.list(request.getHeaderNames());
        for (String header : headerNames) {
            evaluableHeaders.put(header, request.getHeader(header));
        }
        evaluableRequest.setHeaders(evaluableHeaders);
        return evaluableRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForDelay(Long startTime, Long delay) {
        if (delay != null && delay > -1L) {
            log.debug("Mock delay is turned on, waiting if necessary...");
            long duration = System.currentTimeMillis() - startTime;
            if (duration < delay) {
                Object semaphore;
                Object object = semaphore = new Object();
                synchronized (object) {
                    try {
                        semaphore.wait(delay - duration);
                    }
                    catch (Exception e) {
                        log.debug("Delay semaphore was interrupted");
                    }
                }
            }
            log.debug("Delay now expired, releasing response !");
        }
    }

    public static void publishMockInvocation(ApplicationContext applicationContext, Object eventSource, Service service, Response response, Long startTime) {
        MockInvocationEvent event = new MockInvocationEvent(eventSource, service.getName(), service.getVersion(), response.getName(), new Date(startTime), startTime - System.currentTimeMillis());
        applicationContext.publishEvent((ApplicationEvent)event);
        log.debug("Mock invocation event has been published");
    }
}

