/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.BooleanConstant;
import com.querydsl.core.QueryException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.ToStringVisitor;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;

public class BooleanBuilderTest {
    private final BooleanExpression first = BooleanConstant.TRUE;
    private final BooleanExpression second = BooleanConstant.FALSE;

    @Test
    public void null_in_constructor() {
        Assertions.assertThat((Object)new BooleanBuilder(null).getValue()).isNull();
    }

    @Test
    public void and_empty() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)new BooleanBuilder());
        Assertions.assertThat((Object)ExpressionUtils.extract((Expression)builder)).isNull();
    }

    @Test
    public void and_any_of() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.andAnyOf(new Predicate[]{this.first, null});
        Assertions.assertThat((Object)builder.getValue()).isEqualTo((Object)this.first);
    }

    @Test
    public void and_any_of2() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.andAnyOf(new Predicate[]{null, this.first});
        Assertions.assertThat((Object)builder.getValue()).isEqualTo((Object)this.first);
    }

    @Test
    public void or_all_of() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.orAllOf(new Predicate[]{this.first, null});
        Assertions.assertThat((Object)builder.getValue()).isEqualTo((Object)this.first);
    }

    @Test
    public void or_all_of2() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.orAllOf(new Predicate[]{null, this.first});
        Assertions.assertThat((Object)builder.getValue()).isEqualTo((Object)this.first);
    }

    @Test(expected=QueryException.class)
    @Ignore
    public void wrapped_booleanBuilder() {
        new BooleanBuilder((Predicate)new BooleanBuilder());
    }

    @Test
    public void basic() {
        Assertions.assertThat((String)new BooleanBuilder().and((Predicate)this.first).or((Predicate)this.second).toString()).isEqualTo(this.first.or((Predicate)this.second).toString());
    }

    @Test
    public void advanced() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.andAnyOf(new Predicate[]{this.first, this.second, this.first});
        builder.orAllOf(new Predicate[]{this.first, this.second, this.first});
        Assertions.assertThat((String)builder.toString()).isEqualTo("true || false || true || true && false && true");
    }

    @Test
    public void if_then_else() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and(null);
        builder.or(null);
        builder.and((Predicate)this.second);
        Assertions.assertThat((Object)builder.getValue()).isEqualTo((Object)this.second);
    }

    @Test
    public void and_null_supported() {
        Assertions.assertThat((Object)this.first.and(null)).isEqualTo((Object)this.first);
    }

    @Test
    public void or_null_supported() {
        Assertions.assertThat((Object)this.first.or(null)).isEqualTo((Object)this.first);
    }

    @Test
    public void and_not() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)this.first).andNot((Predicate)this.second);
        Assertions.assertThat((Object)builder.getValue()).isEqualTo((Object)this.first.and((Predicate)this.second.not()));
    }

    @Test
    public void or_not() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)this.first).orNot((Predicate)this.second);
        Assertions.assertThat((Object)builder.getValue()).isEqualTo((Object)this.first.or((Predicate)this.second.not()));
    }

    @Test
    public void not() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)this.first).not();
        Assertions.assertThat((Object)builder.getValue()).isEqualTo((Object)this.first.not());
    }

    @Test
    public void booleanBuilder_equals_booleanBuilder() {
        Assertions.assertThat((Object)new BooleanBuilder((Predicate)this.first)).isEqualTo((Object)new BooleanBuilder((Predicate)this.first));
    }

    @Test
    public void constant_equals_booleanBuilder() {
        Assertions.assertThat((boolean)this.first.equals((Object)new BooleanBuilder((Predicate)this.first))).isFalse();
    }

    @Test
    public void booleanBuilder_equals_constant() {
        Assertions.assertThat((boolean)new BooleanBuilder((Predicate)this.first).equals((Object)this.first)).isFalse();
    }

    @Test
    public void hashCode_() {
        Assertions.assertThat((int)new BooleanBuilder((Predicate)this.first).hashCode()).isEqualTo(new BooleanBuilder((Predicate)this.first).hashCode());
        Assertions.assertThat((int)new BooleanBuilder().hashCode()).isEqualTo(new BooleanBuilder().hashCode());
    }

    @Test
    public void toString_() {
        BooleanBuilder builder = new BooleanBuilder().and((Predicate)this.first);
        Assertions.assertThat((String)builder.toString()).isEqualTo("true");
        builder.or((Predicate)Expressions.booleanPath((String)"condition"));
        Assertions.assertThat((String)builder.toString()).isEqualTo("true || condition");
    }

    @Test
    public void accept() {
        BooleanBuilder builder = new BooleanBuilder();
        builder.and((Predicate)this.first);
        builder.or((Predicate)Expressions.booleanPath((String)"condition"));
        Assertions.assertThat((String)((String)builder.accept((Visitor)ToStringVisitor.DEFAULT, (Object)Templates.DEFAULT))).isEqualTo("true || condition");
    }
}

